/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.Condition;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperation;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.LastOperationFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineStatusFluentImpl<A extends MachineStatusFluent<A>>
extends BaseFluent<A>
implements MachineStatusFluent<A> {
    private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String errorMessage;
    private String errorReason;
    private LastOperationBuilder lastOperation;
    private String lastUpdated;
    private ObjectReferenceBuilder nodeRef;
    private String phase;
    private Map<String, Object> providerStatus;
    private Map<String, Object> additionalProperties;

    public MachineStatusFluentImpl() {
    }

    public MachineStatusFluentImpl(MachineStatus instance) {
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorReason(instance.getErrorReason());
        this.withLastOperation(instance.getLastOperation());
        this.withLastUpdated(instance.getLastUpdated());
        this.withNodeRef(instance.getNodeRef());
        this.withPhase(instance.getPhase());
        this.withProviderStatus(instance.getProviderStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAddresses(Integer index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(Integer index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddress>();
        }
        for (NodeAddress item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        for (NodeAddress item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<NodeAddress> getAddresses() {
        return this.addresses;
    }

    @Override
    public NodeAddress getAddress(Integer index) {
        return this.addresses.get(index);
    }

    @Override
    public NodeAddress getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public NodeAddress getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public NodeAddress getMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<NodeAddress> predicate) {
        for (NodeAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<NodeAddress> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<NodeAddress>();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return this.conditions != null ? MachineStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MachineStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public A withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return (A)this;
    }

    @Override
    public Boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    @Override
    public String getErrorReason() {
        return this.errorReason;
    }

    @Override
    public A withErrorReason(String errorReason) {
        this.errorReason = errorReason;
        return (A)this;
    }

    @Override
    public Boolean hasErrorReason() {
        return this.errorReason != null;
    }

    @Override
    @Deprecated
    public LastOperation getLastOperation() {
        return this.lastOperation != null ? this.lastOperation.build() : null;
    }

    @Override
    public LastOperation buildLastOperation() {
        return this.lastOperation != null ? this.lastOperation.build() : null;
    }

    @Override
    public A withLastOperation(LastOperation lastOperation) {
        this._visitables.get("lastOperation").remove(this.lastOperation);
        if (lastOperation != null) {
            this.lastOperation = new LastOperationBuilder(lastOperation);
            this._visitables.get("lastOperation").add(this.lastOperation);
        } else {
            this.lastOperation = null;
            this._visitables.get("lastOperation").remove(this.lastOperation);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    @Override
    public A withNewLastOperation(String description, String lastUpdated, String state, String type) {
        return this.withLastOperation(new LastOperation(description, lastUpdated, state, type));
    }

    @Override
    public MachineStatusFluent.LastOperationNested<A> withNewLastOperation() {
        return new LastOperationNestedImpl();
    }

    @Override
    public MachineStatusFluent.LastOperationNested<A> withNewLastOperationLike(LastOperation item) {
        return new LastOperationNestedImpl(item);
    }

    @Override
    public MachineStatusFluent.LastOperationNested<A> editLastOperation() {
        return this.withNewLastOperationLike(this.getLastOperation());
    }

    @Override
    public MachineStatusFluent.LastOperationNested<A> editOrNewLastOperation() {
        return this.withNewLastOperationLike(this.getLastOperation() != null ? this.getLastOperation() : new LastOperationBuilder().build());
    }

    @Override
    public MachineStatusFluent.LastOperationNested<A> editOrNewLastOperationLike(LastOperation item) {
        return this.withNewLastOperationLike(this.getLastOperation() != null ? this.getLastOperation() : item);
    }

    @Override
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)this;
    }

    @Override
    public Boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    @Override
    @Deprecated
    public ObjectReference getNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    @Override
    public ObjectReference buildNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    @Override
    public A withNodeRef(ObjectReference nodeRef) {
        this._visitables.get("nodeRef").remove(this.nodeRef);
        if (nodeRef != null) {
            this.nodeRef = new ObjectReferenceBuilder(nodeRef);
            this._visitables.get("nodeRef").add(this.nodeRef);
        } else {
            this.nodeRef = null;
            this._visitables.get("nodeRef").remove(this.nodeRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeRef() {
        return this.nodeRef != null;
    }

    @Override
    public MachineStatusFluent.NodeRefNested<A> withNewNodeRef() {
        return new NodeRefNestedImpl();
    }

    @Override
    public MachineStatusFluent.NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
        return new NodeRefNestedImpl(item);
    }

    @Override
    public MachineStatusFluent.NodeRefNested<A> editNodeRef() {
        return this.withNewNodeRefLike(this.getNodeRef());
    }

    @Override
    public MachineStatusFluent.NodeRefNested<A> editOrNewNodeRef() {
        return this.withNewNodeRefLike(this.getNodeRef() != null ? this.getNodeRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public MachineStatusFluent.NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
        return this.withNewNodeRefLike(this.getNodeRef() != null ? this.getNodeRef() : item);
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A addToProviderStatus(String key, Object value) {
        if (this.providerStatus == null && key != null && value != null) {
            this.providerStatus = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.providerStatus.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToProviderStatus(Map<String, Object> map) {
        if (this.providerStatus == null && map != null) {
            this.providerStatus = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.providerStatus.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromProviderStatus(String key) {
        if (this.providerStatus == null) {
            return (A)this;
        }
        if (key != null && this.providerStatus != null) {
            this.providerStatus.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromProviderStatus(Map<String, Object> map) {
        if (this.providerStatus == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.providerStatus == null) continue;
                this.providerStatus.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getProviderStatus() {
        return this.providerStatus;
    }

    @Override
    public <K, V> A withProviderStatus(Map<String, Object> providerStatus) {
        this.providerStatus = providerStatus == null ? null : new LinkedHashMap<String, Object>(providerStatus);
        return (A)this;
    }

    @Override
    public Boolean hasProviderStatus() {
        return this.providerStatus != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineStatusFluentImpl that = (MachineStatusFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(that.errorMessage) : that.errorMessage != null) {
            return false;
        }
        if (this.errorReason != null ? !this.errorReason.equals(that.errorReason) : that.errorReason != null) {
            return false;
        }
        if (this.lastOperation != null ? !this.lastOperation.equals(that.lastOperation) : that.lastOperation != null) {
            return false;
        }
        if (this.lastUpdated != null ? !this.lastUpdated.equals(that.lastUpdated) : that.lastUpdated != null) {
            return false;
        }
        if (this.nodeRef != null ? !this.nodeRef.equals(that.nodeRef) : that.nodeRef != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.providerStatus != null ? !this.providerStatus.equals(that.providerStatus) : that.providerStatus != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.errorMessage, this.errorReason, this.lastOperation, this.lastUpdated, this.nodeRef, this.phase, this.providerStatus, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.errorMessage != null) {
            sb.append("errorMessage:");
            sb.append(this.errorMessage + ",");
        }
        if (this.errorReason != null) {
            sb.append("errorReason:");
            sb.append(this.errorReason + ",");
        }
        if (this.lastOperation != null) {
            sb.append("lastOperation:");
            sb.append(this.lastOperation + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.nodeRef != null) {
            sb.append("nodeRef:");
            sb.append(this.nodeRef + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.providerStatus != null && !this.providerStatus.isEmpty()) {
            sb.append("providerStatus:");
            sb.append(this.providerStatus + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class NodeRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<MachineStatusFluent.NodeRefNested<N>>
    implements MachineStatusFluent.NodeRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        NodeRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        NodeRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluentImpl.this.withNodeRef(this.builder.build());
        }

        @Override
        public N endNodeRef() {
            return this.and();
        }
    }

    class LastOperationNestedImpl<N>
    extends LastOperationFluentImpl<MachineStatusFluent.LastOperationNested<N>>
    implements MachineStatusFluent.LastOperationNested<N>,
    Nested<N> {
        LastOperationBuilder builder;

        LastOperationNestedImpl(LastOperation item) {
            this.builder = new LastOperationBuilder(this, item);
        }

        LastOperationNestedImpl() {
            this.builder = new LastOperationBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluentImpl.this.withLastOperation(this.builder.build());
        }

        @Override
        public N endLastOperation() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<MachineStatusFluent.ConditionsNested<N>>
    implements MachineStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

