/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngress;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluentImpl;

public class ClusterIngressBuilder
extends ClusterIngressFluentImpl<ClusterIngressBuilder>
implements VisitableBuilder<ClusterIngress, ClusterIngressBuilder> {
    ClusterIngressFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterIngressBuilder() {
        this(false);
    }

    public ClusterIngressBuilder(Boolean validationEnabled) {
        this(new ClusterIngress(), validationEnabled);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterIngress(), validationEnabled);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, ClusterIngress instance) {
        this(fluent, instance, false);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, ClusterIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDomain(instance.getDomain());
        fluent.withName(instance.getName());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withRouteSelector(instance.getRouteSelector());
        fluent.withServingCertificate(instance.getServingCertificate());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterIngressBuilder(ClusterIngress instance) {
        this(instance, (Boolean)false);
    }

    public ClusterIngressBuilder(ClusterIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDomain(instance.getDomain());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withRouteSelector(instance.getRouteSelector());
        this.withServingCertificate(instance.getServingCertificate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterIngress build() {
        ClusterIngress buildable = new ClusterIngress(this.fluent.getDomain(), this.fluent.getName(), this.fluent.getNamespaceSelector(), this.fluent.getRouteSelector(), this.fluent.getServingCertificate());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

