/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.config.v1.Network;
import io.fabric8.openshift.api.model.config.v1.NetworkFluent;
import io.fabric8.openshift.api.model.config.v1.NetworkFluentImpl;

public class NetworkBuilder
extends NetworkFluentImpl<NetworkBuilder>
implements VisitableBuilder<Network, NetworkBuilder> {
    NetworkFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkBuilder() {
        this(false);
    }

    public NetworkBuilder(Boolean validationEnabled) {
        this(new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Network(), validationEnabled);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance) {
        this(fluent, instance, false);
    }

    public NetworkBuilder(NetworkFluent<?> fluent, Network instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NetworkBuilder(Network instance) {
        this(instance, (Boolean)false);
    }

    public NetworkBuilder(Network instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Network build() {
        Network buildable = new Network(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

