/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicy;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalIPPolicyFluentImpl<A extends ExternalIPPolicyFluent<A>>
extends BaseFluent<A>
implements ExternalIPPolicyFluent<A> {
    private List<String> allowedCIDRs = new ArrayList<String>();
    private List<String> rejectedCIDRs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ExternalIPPolicyFluentImpl() {
    }

    public ExternalIPPolicyFluentImpl(ExternalIPPolicy instance) {
        this.withAllowedCIDRs(instance.getAllowedCIDRs());
        this.withRejectedCIDRs(instance.getRejectedCIDRs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAllowedCIDRs(Integer index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCIDRs(Integer index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCIDRs(String ... items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCIDRs(Collection<String> items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCIDRs(String ... items) {
        for (String item : items) {
            if (this.allowedCIDRs == null) continue;
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.allowedCIDRs == null) continue;
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCIDRs() {
        return this.allowedCIDRs;
    }

    @Override
    public String getAllowedCIDR(Integer index) {
        return this.allowedCIDRs.get(index);
    }

    @Override
    public String getFirstAllowedCIDR() {
        return this.allowedCIDRs.get(0);
    }

    @Override
    public String getLastAllowedCIDR() {
        return this.allowedCIDRs.get(this.allowedCIDRs.size() - 1);
    }

    @Override
    public String getMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedCIDRs(List<String> allowedCIDRs) {
        if (allowedCIDRs != null) {
            this.allowedCIDRs = new ArrayList<String>();
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        } else {
            this.allowedCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCIDRs(String ... allowedCIDRs) {
        if (this.allowedCIDRs != null) {
            this.allowedCIDRs.clear();
        }
        if (allowedCIDRs != null) {
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCIDRs() {
        return this.allowedCIDRs != null && !this.allowedCIDRs.isEmpty();
    }

    @Override
    public A addToRejectedCIDRs(Integer index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRejectedCIDRs(Integer index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRejectedCIDRs(String ... items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRejectedCIDRs(Collection<String> items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRejectedCIDRs(String ... items) {
        for (String item : items) {
            if (this.rejectedCIDRs == null) continue;
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRejectedCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.rejectedCIDRs == null) continue;
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRejectedCIDRs() {
        return this.rejectedCIDRs;
    }

    @Override
    public String getRejectedCIDR(Integer index) {
        return this.rejectedCIDRs.get(index);
    }

    @Override
    public String getFirstRejectedCIDR() {
        return this.rejectedCIDRs.get(0);
    }

    @Override
    public String getLastRejectedCIDR() {
        return this.rejectedCIDRs.get(this.rejectedCIDRs.size() - 1);
    }

    @Override
    public String getMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRejectedCIDRs(List<String> rejectedCIDRs) {
        if (rejectedCIDRs != null) {
            this.rejectedCIDRs = new ArrayList<String>();
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        } else {
            this.rejectedCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withRejectedCIDRs(String ... rejectedCIDRs) {
        if (this.rejectedCIDRs != null) {
            this.rejectedCIDRs.clear();
        }
        if (rejectedCIDRs != null) {
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRejectedCIDRs() {
        return this.rejectedCIDRs != null && !this.rejectedCIDRs.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIPPolicyFluentImpl that = (ExternalIPPolicyFluentImpl)o;
        if (this.allowedCIDRs != null ? !this.allowedCIDRs.equals(that.allowedCIDRs) : that.allowedCIDRs != null) {
            return false;
        }
        if (this.rejectedCIDRs != null ? !this.rejectedCIDRs.equals(that.rejectedCIDRs) : that.rejectedCIDRs != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedCIDRs, this.rejectedCIDRs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedCIDRs != null && !this.allowedCIDRs.isEmpty()) {
            sb.append("allowedCIDRs:");
            sb.append(this.allowedCIDRs + ",");
        }
        if (this.rejectedCIDRs != null && !this.rejectedCIDRs.isEmpty()) {
            sb.append("rejectedCIDRs:");
            sb.append(this.rejectedCIDRs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

