/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatcherWebSocketListener<T extends HasMetadata>
implements WebSocket.Listener {
    protected static final Logger logger = LoggerFactory.getLogger(WatcherWebSocketListener.class);
    protected final AbstractWatchManager<T> manager;
    private AtomicBoolean reconnected = new AtomicBoolean();
    private AtomicBoolean closed = new AtomicBoolean();

    protected WatcherWebSocketListener(AbstractWatchManager<T> manager) {
        this.manager = manager;
    }

    public void onOpen(WebSocket webSocket) {
        logger.debug("WebSocket successfully opened");
        this.manager.resetReconnectAttempts();
    }

    public void onError(WebSocket webSocket, Throwable t) {
        logger.debug("WebSocket error received", t);
        this.scheduleReconnect();
    }

    public void onMessage(WebSocket webSocket, String text) {
        try {
            if (!this.closed.get()) {
                this.manager.onMessage(text);
            }
        }
        finally {
            webSocket.request();
        }
    }

    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        this.onMessage(webSocket, StandardCharsets.UTF_8.decode(bytes).toString());
    }

    public void onClose(WebSocket webSocket, int code, String reason) {
        logger.debug("WebSocket close received. code: {}, reason: {}", (Object)code, (Object)reason);
        webSocket.sendClose(code, reason);
        this.scheduleReconnect();
    }

    private void scheduleReconnect() {
        if (this.reconnected.compareAndSet(false, true)) {
            this.manager.scheduleReconnect();
        }
    }

    public void close() {
        this.closed.set(true);
    }
}

