/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private static final Set<String> RETRIABLE_RESOURCES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(HasMetadata.getPlural(LocalSubjectAccessReview.class), HasMetadata.getPlural(LocalResourceAccessReview.class), HasMetadata.getPlural(ResourceAccessReview.class), HasMetadata.getPlural(SelfSubjectRulesReview.class), HasMetadata.getPlural(SubjectRulesReview.class), HasMetadata.getPlural(SubjectAccessReview.class), HasMetadata.getPlural(SelfSubjectAccessReview.class))));
    private final HttpClient client;
    private final Config config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(HttpClient client, Config config) {
        this.client = client;
        this.config = config;
    }

    public Interceptor withConfig(Config config) {
        return new OpenShiftOAuthInterceptor(this.client, config);
    }

    public void before(BasicBuilder builder, HttpHeaders headers) {
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty((String)token) && (headers.headers(AUTHORIZATION).isEmpty() || Utils.isNullOrEmpty((String)((String)headers.headers(AUTHORIZATION).get(0))))) {
            this.setAuthHeader(builder, token);
        }
    }

    public CompletableFuture<Boolean> afterFailure(HttpRequest.Builder builder, HttpResponse<?> response) {
        if (this.shouldProceed(response.request(), response)) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Object> tokenFuture = null;
        tokenFuture = Utils.isNotNullOrEmpty((String)this.config.getUsername()) && Utils.isNotNullOrEmpty((String)this.config.getPassword()) ? this.authorize() : CompletableFuture.completedFuture(Utils.getNonNullOrElse((Object)this.config.getOauthToken(), (Object)this.oauthToken.get()));
        return tokenFuture.thenApply(t -> {
            if (t != null) {
                this.oauthToken.set((String)t);
            }
            if (Utils.isNotNullOrEmpty((String)t)) {
                this.setAuthHeader((BasicBuilder)builder, (String)t);
                return true;
            }
            return false;
        });
    }

    private void setAuthHeader(BasicBuilder builder, String token) {
        if (token != null) {
            builder.setHeader(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    private CompletableFuture<String> authorize() {
        URL url;
        HttpClient.DerivedClientBuilder builder = this.client.newBuilder();
        builder.addOrReplaceInterceptor("TOKEN", null);
        HttpClient clone = builder.build();
        try {
            url = new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), AUTHORIZATION_SERVER_PATH}));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        CompletableFuture responseFuture = clone.sendAsync(clone.newHttpRequestBuilder().url(url).build(), String.class);
        return ((CompletableFuture)responseFuture.thenCompose(response -> {
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = (String)response.body();
            try {
                JsonNode jsonResponse = Serialization.jsonMapper().readTree(body);
                String authorizationServer = jsonResponse.get("authorization_endpoint").asText();
                URL authorizeQuery = new URL(authorizationServer + AUTHORIZE_QUERY);
                String credential = HttpClientUtils.basicCredentials((String)this.config.getUsername(), (String)this.config.getPassword());
                return clone.sendAsync(this.client.newHttpRequestBuilder().url(authorizeQuery).setHeader(AUTHORIZATION, credential).build(), String.class);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        })).thenApply(response -> {
            String token;
            HttpResponse responseOrPrevious = response.previousResponse().isPresent() ? (HttpResponse)response.previousResponse().get() : response;
            List location = responseOrPrevious.headers(LOCATION);
            String string = token = !location.isEmpty() ? (String)location.get(0) : null;
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + responseOrPrevious.code() + " " + responseOrPrevious.message() + "), to the authorization request. Missing header:[" + LOCATION + "]!");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        });
    }

    private boolean shouldProceed(HttpRequest request, HttpResponse<?> response) {
        String url = request.uri().toString();
        String method = request.method();
        if (method.equals("POST")) {
            if (RETRIABLE_RESOURCES.stream().anyMatch(url::endsWith)) {
                return false;
            }
        }
        return response.code() != 401 && response.code() != 403;
    }
}

