/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RoutePortFluentImpl;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.RouteTargetReferenceFluentImpl;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.api.model.TLSConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>>
extends BaseFluent<A>
implements RouteSpecFluent<A> {
    private ArrayList<RouteTargetReferenceBuilder> alternateBackends = new ArrayList();
    private String host;
    private String path;
    private RoutePortBuilder port;
    private String subdomain;
    private TLSConfigBuilder tls;
    private RouteTargetReferenceBuilder to;
    private String wildcardPolicy;
    private Map<String, Object> additionalProperties;

    public RouteSpecFluentImpl() {
    }

    public RouteSpecFluentImpl(RouteSpec instance) {
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withSubdomain(instance.getSubdomain());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAlternateBackends(Integer index, RouteTargetReference item) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        this._visitables.get("alternateBackends").add(index >= 0 ? index.intValue() : this._visitables.get("alternateBackends").size(), builder);
        this.alternateBackends.add(index >= 0 ? index.intValue() : this.alternateBackends.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAlternateBackends(Integer index, RouteTargetReference item) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("alternateBackends").size()) {
            this._visitables.get("alternateBackends").add(builder);
        } else {
            this._visitables.get("alternateBackends").set(index, builder);
        }
        if (index < 0 || index >= this.alternateBackends.size()) {
            this.alternateBackends.add(builder);
        } else {
            this.alternateBackends.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAlternateBackends(RouteTargetReference ... items) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAlternateBackends(Collection<RouteTargetReference> items) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAlternateBackends(RouteTargetReference ... items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").remove(builder);
            if (this.alternateBackends == null) continue;
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAlternateBackends(Collection<RouteTargetReference> items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").remove(builder);
            if (this.alternateBackends == null) continue;
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAlternateBackends(Predicate<RouteTargetReferenceBuilder> predicate) {
        if (this.alternateBackends == null) {
            return (A)this;
        }
        Iterator<RouteTargetReferenceBuilder> each = this.alternateBackends.iterator();
        Object visitables = this._visitables.get("alternateBackends");
        while (each.hasNext()) {
            RouteTargetReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteTargetReference> getAlternateBackends() {
        return this.alternateBackends != null ? RouteSpecFluentImpl.build(this.alternateBackends) : null;
    }

    @Override
    public List<RouteTargetReference> buildAlternateBackends() {
        return this.alternateBackends != null ? RouteSpecFluentImpl.build(this.alternateBackends) : null;
    }

    @Override
    public RouteTargetReference buildAlternateBackend(Integer index) {
        return this.alternateBackends.get(index).build();
    }

    @Override
    public RouteTargetReference buildFirstAlternateBackend() {
        return this.alternateBackends.get(0).build();
    }

    @Override
    public RouteTargetReference buildLastAlternateBackend() {
        return this.alternateBackends.get(this.alternateBackends.size() - 1).build();
    }

    @Override
    public RouteTargetReference buildMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        for (RouteTargetReferenceBuilder item : this.alternateBackends) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        for (RouteTargetReferenceBuilder item : this.alternateBackends) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
        if (this.alternateBackends != null) {
            this._visitables.get("alternateBackends").removeAll(this.alternateBackends);
        }
        if (alternateBackends != null) {
            this.alternateBackends = new ArrayList();
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        } else {
            this.alternateBackends = null;
        }
        return (A)this;
    }

    @Override
    public A withAlternateBackends(RouteTargetReference ... alternateBackends) {
        if (this.alternateBackends != null) {
            this.alternateBackends.clear();
        }
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAlternateBackends() {
        return this.alternateBackends != null && !this.alternateBackends.isEmpty();
    }

    @Override
    public A addNewAlternateBackend(String kind, String name, Integer weight) {
        return this.addToAlternateBackends(new RouteTargetReference(kind, name, weight));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend() {
        return new AlternateBackendsNestedImpl();
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
        return new AlternateBackendsNestedImpl(-1, item);
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> setNewAlternateBackendLike(Integer index, RouteTargetReference item) {
        return new AlternateBackendsNestedImpl(index, item);
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editAlternateBackend(Integer index) {
        if (this.alternateBackends.size() <= index) {
            throw new RuntimeException("Can't edit alternateBackends. Index exceeds size.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editFirstAlternateBackend() {
        if (this.alternateBackends.size() == 0) {
            throw new RuntimeException("Can't edit first alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(0, this.buildAlternateBackend(0));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editLastAlternateBackend() {
        int index = this.alternateBackends.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.alternateBackends.size(); ++i) {
            if (!predicate.test(this.alternateBackends.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching alternateBackends. No match found.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public RoutePort getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public RoutePort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(RoutePort port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new RoutePortBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new RoutePortBuilder().build());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPortLike(RoutePort item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    @Deprecated
    public TLSConfig getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public TLSConfig buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(TLSConfig tls) {
        this._visitables.get("tls").remove(this.tls);
        if (tls != null) {
            this.tls = new TLSConfigBuilder(tls);
            this._visitables.get("tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get("tls").remove(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new TLSConfigBuilder().build());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTlsLike(TLSConfig item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public RouteTargetReference getTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public RouteTargetReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public A withTo(RouteTargetReference to) {
        this._visitables.get("to").remove(this.to);
        if (to != null) {
            this.to = new RouteTargetReferenceBuilder(to);
            this._visitables.get("to").add(this.to);
        } else {
            this.to = null;
            this._visitables.get("to").remove(this.to);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null;
    }

    @Override
    public A withNewTo(String kind, String name, Integer weight) {
        return this.withTo(new RouteTargetReference(kind, name, weight));
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new RouteTargetReferenceBuilder().build());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewToLike(RouteTargetReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    @Override
    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    @Override
    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteSpecFluentImpl that = (RouteSpecFluentImpl)o;
        if (this.alternateBackends != null ? !this.alternateBackends.equals(that.alternateBackends) : that.alternateBackends != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        if (this.wildcardPolicy != null ? !this.wildcardPolicy.equals(that.wildcardPolicy) : that.wildcardPolicy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alternateBackends, this.host, this.path, this.port, this.subdomain, this.tls, this.to, this.wildcardPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alternateBackends != null && !this.alternateBackends.isEmpty()) {
            sb.append("alternateBackends:");
            sb.append(this.alternateBackends + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ToNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.ToNested<N>>
    implements RouteSpecFluent.ToNested<N>,
    Nested<N> {
        RouteTargetReferenceBuilder builder;

        ToNestedImpl(RouteTargetReference item) {
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    class TlsNestedImpl<N>
    extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>>
    implements RouteSpecFluent.TlsNested<N>,
    Nested<N> {
        TLSConfigBuilder builder;

        TlsNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    class PortNestedImpl<N>
    extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>>
    implements RouteSpecFluent.PortNested<N>,
    Nested<N> {
        RoutePortBuilder builder;

        PortNestedImpl(RoutePort item) {
            this.builder = new RoutePortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new RoutePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class AlternateBackendsNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.AlternateBackendsNested<N>>
    implements RouteSpecFluent.AlternateBackendsNested<N>,
    Nested<N> {
        RouteTargetReferenceBuilder builder;
        Integer index;

        AlternateBackendsNestedImpl(Integer index, RouteTargetReference item) {
            this.index = index;
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        AlternateBackendsNestedImpl() {
            this.index = -1;
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.setToAlternateBackends(this.index, this.builder.build());
        }

        @Override
        public N endAlternateBackend() {
            return this.and();
        }
    }
}

