/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import java.util.concurrent.TimeUnit;

public class RollingOperationContext {
    private final PodOperationContext podOperationContext;
    private boolean rolling;
    private long rollingTimeout;
    private TimeUnit rollingTimeUnit;

    public RollingOperationContext() {
        this.podOperationContext = new PodOperationContext();
    }

    public RollingOperationContext(PodOperationContext podOperationContext, boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        this.podOperationContext = podOperationContext;
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit != null ? rollingTimeUnit : TimeUnit.MILLISECONDS;
    }

    public PodOperationContext getPodOperationContext() {
        return this.podOperationContext;
    }

    public Boolean getRolling() {
        return this.rolling;
    }

    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    public TimeUnit getRollingTimeUnit() {
        return this.rollingTimeUnit;
    }

    public RollingOperationContext withRolling(boolean rolling) {
        return new RollingOperationContext(this.podOperationContext, rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withRollingTimeout(long rollingTimeout) {
        return new RollingOperationContext(this.podOperationContext, this.rolling, rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withRollingTimeUnit(TimeUnit rollingTimeUnit) {
        return new RollingOperationContext(this.podOperationContext, this.rolling, this.rollingTimeout, rollingTimeUnit);
    }

    public RollingOperationContext withContainerId(String containerId) {
        return new RollingOperationContext(this.podOperationContext.withContainerId(containerId), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withLogWaitTimeout(Integer logWaitTimeout) {
        return new RollingOperationContext(this.podOperationContext.withLogWaitTimeout(logWaitTimeout), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withLimitBytes(Integer limitBytes) {
        return new RollingOperationContext(this.podOperationContext.withLimitBytes(limitBytes), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withTerminatedStatus(boolean terminatedStatus) {
        return new RollingOperationContext(this.podOperationContext.withTerminatedStatus(terminatedStatus), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withPrettyOutput(boolean prettyOutput) {
        return new RollingOperationContext(this.podOperationContext.withPrettyOutput(prettyOutput), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withTailingLines(Integer tailingLines) {
        return new RollingOperationContext(this.podOperationContext.withTailingLines(tailingLines), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withSinceTimestamp(String sinceTimestamp) {
        return new RollingOperationContext(this.podOperationContext.withSinceTimestamp(sinceTimestamp), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withSinceSeconds(Integer sinceSeconds) {
        return new RollingOperationContext(this.podOperationContext.withSinceSeconds(sinceSeconds), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    public RollingOperationContext withTimestamps(boolean timestamps) {
        return new RollingOperationContext(this.podOperationContext.withTimestamps(timestamps), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }
}

