/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLAN;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLANBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLANFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NICFluent<A extends NICFluent<A>>
extends BaseFluent<A> {
    private String ip;
    private String mac;
    private String model;
    private String name;
    private Boolean pxe;
    private Integer speedGbps;
    private Integer vlanId;
    private ArrayList<VLANBuilder> vlans = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NICFluent() {
    }

    public NICFluent(NIC instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NIC instance) {
        NIC nIC = instance = instance != null ? instance : new NIC();
        if (instance != null) {
            this.withIp(instance.getIp());
            this.withMac(instance.getMac());
            this.withModel(instance.getModel());
            this.withName(instance.getName());
            this.withPxe(instance.getPxe());
            this.withSpeedGbps(instance.getSpeedGbps());
            this.withVlanId(instance.getVlanId());
            this.withVlans(instance.getVlans());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public String getMac() {
        return this.mac;
    }

    public A withMac(String mac) {
        this.mac = mac;
        return (A)this;
    }

    public boolean hasMac() {
        return this.mac != null;
    }

    public String getModel() {
        return this.model;
    }

    public A withModel(String model) {
        this.model = model;
        return (A)this;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getPxe() {
        return this.pxe;
    }

    public A withPxe(Boolean pxe) {
        this.pxe = pxe;
        return (A)this;
    }

    public boolean hasPxe() {
        return this.pxe != null;
    }

    public Integer getSpeedGbps() {
        return this.speedGbps;
    }

    public A withSpeedGbps(Integer speedGbps) {
        this.speedGbps = speedGbps;
        return (A)this;
    }

    public boolean hasSpeedGbps() {
        return this.speedGbps != null;
    }

    public Integer getVlanId() {
        return this.vlanId;
    }

    public A withVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return (A)this;
    }

    public boolean hasVlanId() {
        return this.vlanId != null;
    }

    public A addToVlans(int index, VLAN item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        VLANBuilder builder = new VLANBuilder(item);
        if (index < 0 || index >= this.vlans.size()) {
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        } else {
            this._visitables.get("vlans").add(index, builder);
            this.vlans.add(index, builder);
        }
        return (A)this;
    }

    public A setToVlans(int index, VLAN item) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        VLANBuilder builder = new VLANBuilder(item);
        if (index < 0 || index >= this.vlans.size()) {
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        } else {
            this._visitables.get("vlans").set(index, builder);
            this.vlans.set(index, builder);
        }
        return (A)this;
    }

    public A addToVlans(VLAN ... items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    public A addAllToVlans(Collection<VLAN> items) {
        if (this.vlans == null) {
            this.vlans = new ArrayList();
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get("vlans").add(builder);
            this.vlans.add(builder);
        }
        return (A)this;
    }

    public A removeFromVlans(VLAN ... items) {
        if (this.vlans == null) {
            return (A)this;
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get("vlans").remove(builder);
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVlans(Collection<VLAN> items) {
        if (this.vlans == null) {
            return (A)this;
        }
        for (VLAN item : items) {
            VLANBuilder builder = new VLANBuilder(item);
            this._visitables.get("vlans").remove(builder);
            this.vlans.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVlans(Predicate<VLANBuilder> predicate) {
        if (this.vlans == null) {
            return (A)this;
        }
        Iterator<VLANBuilder> each = this.vlans.iterator();
        Object visitables = this._visitables.get("vlans");
        while (each.hasNext()) {
            VLANBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<VLAN> buildVlans() {
        return this.vlans != null ? NICFluent.build(this.vlans) : null;
    }

    public VLAN buildVlan(int index) {
        return this.vlans.get(index).build();
    }

    public VLAN buildFirstVlan() {
        return this.vlans.get(0).build();
    }

    public VLAN buildLastVlan() {
        return this.vlans.get(this.vlans.size() - 1).build();
    }

    public VLAN buildMatchingVlan(Predicate<VLANBuilder> predicate) {
        for (VLANBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVlan(Predicate<VLANBuilder> predicate) {
        for (VLANBuilder item : this.vlans) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVlans(List<VLAN> vlans) {
        if (this.vlans != null) {
            this._visitables.get("vlans").clear();
        }
        if (vlans != null) {
            this.vlans = new ArrayList();
            for (VLAN item : vlans) {
                this.addToVlans(item);
            }
        } else {
            this.vlans = null;
        }
        return (A)this;
    }

    public A withVlans(VLAN ... vlans) {
        if (this.vlans != null) {
            this.vlans.clear();
            this._visitables.remove("vlans");
        }
        if (vlans != null) {
            for (VLAN item : vlans) {
                this.addToVlans(item);
            }
        }
        return (A)this;
    }

    public boolean hasVlans() {
        return this.vlans != null && !this.vlans.isEmpty();
    }

    public A addNewVlan(Integer id, String name) {
        return this.addToVlans(new VLAN(id, name));
    }

    public VlansNested<A> addNewVlan() {
        return new VlansNested(-1, null);
    }

    public VlansNested<A> addNewVlanLike(VLAN item) {
        return new VlansNested(-1, item);
    }

    public VlansNested<A> setNewVlanLike(int index, VLAN item) {
        return new VlansNested(index, item);
    }

    public VlansNested<A> editVlan(int index) {
        if (this.vlans.size() <= index) {
            throw new RuntimeException("Can't edit vlans. Index exceeds size.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public VlansNested<A> editFirstVlan() {
        if (this.vlans.size() == 0) {
            throw new RuntimeException("Can't edit first vlans. The list is empty.");
        }
        return this.setNewVlanLike(0, this.buildVlan(0));
    }

    public VlansNested<A> editLastVlan() {
        int index = this.vlans.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last vlans. The list is empty.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public VlansNested<A> editMatchingVlan(Predicate<VLANBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vlans.size(); ++i) {
            if (!predicate.test(this.vlans.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching vlans. No match found.");
        }
        return this.setNewVlanLike(index, this.buildVlan(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NICFluent that = (NICFluent)o;
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        if (!Objects.equals(this.mac, that.mac)) {
            return false;
        }
        if (!Objects.equals(this.model, that.model)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.pxe, that.pxe)) {
            return false;
        }
        if (!Objects.equals(this.speedGbps, that.speedGbps)) {
            return false;
        }
        if (!Objects.equals(this.vlanId, that.vlanId)) {
            return false;
        }
        if (!Objects.equals(this.vlans, that.vlans)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ip, this.mac, this.model, this.name, this.pxe, this.speedGbps, this.vlanId, this.vlans, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.mac != null) {
            sb.append("mac:");
            sb.append(this.mac + ",");
        }
        if (this.model != null) {
            sb.append("model:");
            sb.append(this.model + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.pxe != null) {
            sb.append("pxe:");
            sb.append(this.pxe + ",");
        }
        if (this.speedGbps != null) {
            sb.append("speedGbps:");
            sb.append(this.speedGbps + ",");
        }
        if (this.vlanId != null) {
            sb.append("vlanId:");
            sb.append(this.vlanId + ",");
        }
        if (this.vlans != null && !this.vlans.isEmpty()) {
            sb.append("vlans:");
            sb.append(this.vlans + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPxe() {
        return this.withPxe(true);
    }

    public class VlansNested<N>
    extends VLANFluent<VlansNested<N>>
    implements Nested<N> {
        VLANBuilder builder;
        int index;

        VlansNested(int index, VLAN item) {
            this.index = index;
            this.builder = new VLANBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NICFluent.this.setToVlans(this.index, this.builder.build());
        }

        public N endVlan() {
            return this.and();
        }
    }
}

