/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.OSDiskFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String confidentialCompute;
    private String onHostMaintenance;
    private OSDiskBuilder osDisk;
    private String secureBoot;
    private List<String> tags = new ArrayList<String>();
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withConfidentialCompute(instance.getConfidentialCompute());
            this.withOnHostMaintenance(instance.getOnHostMaintenance());
            this.withOsDisk(instance.getOsDisk());
            this.withSecureBoot(instance.getSecureBoot());
            this.withTags(instance.getTags());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getConfidentialCompute() {
        return this.confidentialCompute;
    }

    public A withConfidentialCompute(String confidentialCompute) {
        this.confidentialCompute = confidentialCompute;
        return (A)this;
    }

    public boolean hasConfidentialCompute() {
        return this.confidentialCompute != null;
    }

    public String getOnHostMaintenance() {
        return this.onHostMaintenance;
    }

    public A withOnHostMaintenance(String onHostMaintenance) {
        this.onHostMaintenance = onHostMaintenance;
        return (A)this;
    }

    public boolean hasOnHostMaintenance() {
        return this.onHostMaintenance != null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public String getSecureBoot() {
        return this.secureBoot;
    }

    public A withSecureBoot(String secureBoot) {
        this.secureBoot = secureBoot;
        return (A)this;
    }

    public boolean hasSecureBoot() {
        return this.secureBoot != null;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)this;
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove("tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.confidentialCompute, that.confidentialCompute)) {
            return false;
        }
        if (!Objects.equals(this.onHostMaintenance, that.onHostMaintenance)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.secureBoot, that.secureBoot)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.confidentialCompute, this.onHostMaintenance, this.osDisk, this.secureBoot, this.tags, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.confidentialCompute != null) {
            sb.append("confidentialCompute:");
            sb.append(this.confidentialCompute + ",");
        }
        if (this.onHostMaintenance != null) {
            sb.append("onHostMaintenance:");
            sb.append(this.onHostMaintenance + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk + ",");
        }
        if (this.secureBoot != null) {
            sb.append("secureBoot:");
            sb.append(this.secureBoot + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }
}

