/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption;
import io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOptionBuilder;
import io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOptionFluent;
import io.fabric8.openshift.api.model.installer.libvirt.v1.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkFluent<A extends NetworkFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DnsmasqOptionBuilder> dnsmasqOptions = new ArrayList();
    private String _if;
    private Map<String, Object> additionalProperties;

    public NetworkFluent() {
    }

    public NetworkFluent(Network instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Network instance) {
        Network network = instance = instance != null ? instance : new Network();
        if (instance != null) {
            this.withDnsmasqOptions(instance.getDnsmasqOptions());
            this.withIf(instance.getIf());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDnsmasqOptions(int index, DnsmasqOption item) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList();
        }
        DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
        if (index < 0 || index >= this.dnsmasqOptions.size()) {
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        } else {
            this._visitables.get("dnsmasqOptions").add(index, builder);
            this.dnsmasqOptions.add(index, builder);
        }
        return (A)this;
    }

    public A setToDnsmasqOptions(int index, DnsmasqOption item) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList();
        }
        DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
        if (index < 0 || index >= this.dnsmasqOptions.size()) {
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        } else {
            this._visitables.get("dnsmasqOptions").set(index, builder);
            this.dnsmasqOptions.set(index, builder);
        }
        return (A)this;
    }

    public A addToDnsmasqOptions(DnsmasqOption ... items) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList();
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        }
        return (A)this;
    }

    public A addAllToDnsmasqOptions(Collection<DnsmasqOption> items) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList();
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        }
        return (A)this;
    }

    public A removeFromDnsmasqOptions(DnsmasqOption ... items) {
        if (this.dnsmasqOptions == null) {
            return (A)this;
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").remove(builder);
            this.dnsmasqOptions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDnsmasqOptions(Collection<DnsmasqOption> items) {
        if (this.dnsmasqOptions == null) {
            return (A)this;
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").remove(builder);
            this.dnsmasqOptions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDnsmasqOptions(Predicate<DnsmasqOptionBuilder> predicate) {
        if (this.dnsmasqOptions == null) {
            return (A)this;
        }
        Iterator<DnsmasqOptionBuilder> each = this.dnsmasqOptions.iterator();
        Object visitables = this._visitables.get("dnsmasqOptions");
        while (each.hasNext()) {
            DnsmasqOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DnsmasqOption> buildDnsmasqOptions() {
        return this.dnsmasqOptions != null ? NetworkFluent.build(this.dnsmasqOptions) : null;
    }

    public DnsmasqOption buildDnsmasqOption(int index) {
        return this.dnsmasqOptions.get(index).build();
    }

    public DnsmasqOption buildFirstDnsmasqOption() {
        return this.dnsmasqOptions.get(0).build();
    }

    public DnsmasqOption buildLastDnsmasqOption() {
        return this.dnsmasqOptions.get(this.dnsmasqOptions.size() - 1).build();
    }

    public DnsmasqOption buildMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        for (DnsmasqOptionBuilder item : this.dnsmasqOptions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        for (DnsmasqOptionBuilder item : this.dnsmasqOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsmasqOptions(List<DnsmasqOption> dnsmasqOptions) {
        if (this.dnsmasqOptions != null) {
            this._visitables.get("dnsmasqOptions").clear();
        }
        if (dnsmasqOptions != null) {
            this.dnsmasqOptions = new ArrayList();
            for (DnsmasqOption item : dnsmasqOptions) {
                this.addToDnsmasqOptions(item);
            }
        } else {
            this.dnsmasqOptions = null;
        }
        return (A)this;
    }

    public A withDnsmasqOptions(DnsmasqOption ... dnsmasqOptions) {
        if (this.dnsmasqOptions != null) {
            this.dnsmasqOptions.clear();
            this._visitables.remove("dnsmasqOptions");
        }
        if (dnsmasqOptions != null) {
            for (DnsmasqOption item : dnsmasqOptions) {
                this.addToDnsmasqOptions(item);
            }
        }
        return (A)this;
    }

    public boolean hasDnsmasqOptions() {
        return this.dnsmasqOptions != null && !this.dnsmasqOptions.isEmpty();
    }

    public A addNewDnsmasqOption(String name, String value) {
        return this.addToDnsmasqOptions(new DnsmasqOption(name, value));
    }

    public DnsmasqOptionsNested<A> addNewDnsmasqOption() {
        return new DnsmasqOptionsNested(-1, null);
    }

    public DnsmasqOptionsNested<A> addNewDnsmasqOptionLike(DnsmasqOption item) {
        return new DnsmasqOptionsNested(-1, item);
    }

    public DnsmasqOptionsNested<A> setNewDnsmasqOptionLike(int index, DnsmasqOption item) {
        return new DnsmasqOptionsNested(index, item);
    }

    public DnsmasqOptionsNested<A> editDnsmasqOption(int index) {
        if (this.dnsmasqOptions.size() <= index) {
            throw new RuntimeException("Can't edit dnsmasqOptions. Index exceeds size.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    public DnsmasqOptionsNested<A> editFirstDnsmasqOption() {
        if (this.dnsmasqOptions.size() == 0) {
            throw new RuntimeException("Can't edit first dnsmasqOptions. The list is empty.");
        }
        return this.setNewDnsmasqOptionLike(0, this.buildDnsmasqOption(0));
    }

    public DnsmasqOptionsNested<A> editLastDnsmasqOption() {
        int index = this.dnsmasqOptions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dnsmasqOptions. The list is empty.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    public DnsmasqOptionsNested<A> editMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dnsmasqOptions.size(); ++i) {
            if (!predicate.test(this.dnsmasqOptions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dnsmasqOptions. No match found.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    public String getIf() {
        return this._if;
    }

    public A withIf(String _if) {
        this._if = _if;
        return (A)this;
    }

    public boolean hasIf() {
        return this._if != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkFluent that = (NetworkFluent)o;
        if (!Objects.equals(this.dnsmasqOptions, that.dnsmasqOptions)) {
            return false;
        }
        if (!Objects.equals(this._if, that._if)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dnsmasqOptions, this._if, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsmasqOptions != null && !this.dnsmasqOptions.isEmpty()) {
            sb.append("dnsmasqOptions:");
            sb.append(this.dnsmasqOptions + ",");
        }
        if (this._if != null) {
            sb.append("_if:");
            sb.append(this._if + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DnsmasqOptionsNested<N>
    extends DnsmasqOptionFluent<DnsmasqOptionsNested<N>>
    implements Nested<N> {
        DnsmasqOptionBuilder builder;
        int index;

        DnsmasqOptionsNested(int index, DnsmasqOption item) {
            this.index = index;
            this.builder = new DnsmasqOptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkFluent.this.setToDnsmasqOptions(this.index, this.builder.build());
        }

        public N endDnsmasqOption() {
            return this.and();
        }
    }
}

