/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EphemeralVolumeSource;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaim;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaimBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class StorageSpecFluentImpl<A extends StorageSpecFluent<A>>
extends BaseFluent<A>
implements StorageSpecFluent<A> {
    private Boolean disableMountSubPath;
    private EmptyDirVolumeSource emptyDir;
    private EphemeralVolumeSource ephemeral;
    private EmbeddedPersistentVolumeClaimBuilder volumeClaimTemplate;
    private Map<String, Object> additionalProperties;

    public StorageSpecFluentImpl() {
    }

    public StorageSpecFluentImpl(StorageSpec instance) {
        this.withDisableMountSubPath(instance.getDisableMountSubPath());
        this.withEmptyDir(instance.getEmptyDir());
        this.withEphemeral(instance.getEphemeral());
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getDisableMountSubPath() {
        return this.disableMountSubPath;
    }

    @Override
    public A withDisableMountSubPath(Boolean disableMountSubPath) {
        this.disableMountSubPath = disableMountSubPath;
        return (A)this;
    }

    @Override
    public Boolean hasDisableMountSubPath() {
        return this.disableMountSubPath != null;
    }

    @Override
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    @Override
    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
        return (A)this;
    }

    @Override
    public Boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    @Override
    public EphemeralVolumeSource getEphemeral() {
        return this.ephemeral;
    }

    @Override
    public A withEphemeral(EphemeralVolumeSource ephemeral) {
        this.ephemeral = ephemeral;
        return (A)this;
    }

    @Override
    public Boolean hasEphemeral() {
        return this.ephemeral != null;
    }

    @Override
    @Deprecated
    public EmbeddedPersistentVolumeClaim getVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public EmbeddedPersistentVolumeClaim buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public A withVolumeClaimTemplate(EmbeddedPersistentVolumeClaim volumeClaimTemplate) {
        this._visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate != null) {
            this.volumeClaimTemplate = new EmbeddedPersistentVolumeClaimBuilder(volumeClaimTemplate);
            this._visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);
        } else {
            this.volumeClaimTemplate = null;
            this._visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate());
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : new EmbeddedPersistentVolumeClaimBuilder().build());
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageSpecFluentImpl that = (StorageSpecFluentImpl)o;
        if (this.disableMountSubPath != null ? !this.disableMountSubPath.equals(that.disableMountSubPath) : that.disableMountSubPath != null) {
            return false;
        }
        if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) {
            return false;
        }
        if (this.ephemeral != null ? !this.ephemeral.equals(that.ephemeral) : that.ephemeral != null) {
            return false;
        }
        if (this.volumeClaimTemplate != null ? !this.volumeClaimTemplate.equals(that.volumeClaimTemplate) : that.volumeClaimTemplate != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.disableMountSubPath, this.emptyDir, this.ephemeral, this.volumeClaimTemplate, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableMountSubPath != null) {
            sb.append("disableMountSubPath:");
            sb.append(this.disableMountSubPath + ",");
        }
        if (this.emptyDir != null) {
            sb.append("emptyDir:");
            sb.append(this.emptyDir + ",");
        }
        if (this.ephemeral != null) {
            sb.append("ephemeral:");
            sb.append(this.ephemeral + ",");
        }
        if (this.volumeClaimTemplate != null) {
            sb.append("volumeClaimTemplate:");
            sb.append(this.volumeClaimTemplate + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDisableMountSubPath() {
        return this.withDisableMountSubPath(true);
    }

    class VolumeClaimTemplateNestedImpl<N>
    extends EmbeddedPersistentVolumeClaimFluentImpl<StorageSpecFluent.VolumeClaimTemplateNested<N>>
    implements StorageSpecFluent.VolumeClaimTemplateNested<N>,
    Nested<N> {
        EmbeddedPersistentVolumeClaimBuilder builder;

        VolumeClaimTemplateNestedImpl(EmbeddedPersistentVolumeClaim item) {
            this.builder = new EmbeddedPersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplateNestedImpl() {
            this.builder = new EmbeddedPersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)StorageSpecFluentImpl.this.withVolumeClaimTemplate(this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

