/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.UserRestriction;
import io.fabric8.openshift.api.model.UserRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UserRestrictionFluentImpl<A extends UserRestrictionFluent<A>>
extends BaseFluent<A>
implements UserRestrictionFluent<A> {
    private List<String> groups = new ArrayList<String>();
    private ArrayList<LabelSelectorBuilder> labels = new ArrayList();
    private List<String> users = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public UserRestrictionFluentImpl() {
    }

    public UserRestrictionFluentImpl(UserRestriction instance) {
        this.withGroups(instance.getGroups());
        this.withLabels(instance.getLabels());
        this.withUsers(instance.getUsers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(Integer index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addToLabels(Integer index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        this._visitables.get("labels").add(index >= 0 ? index.intValue() : this._visitables.get("labels").size(), builder);
        this.labels.add(index >= 0 ? index.intValue() : this.labels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLabels(Integer index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get("labels").size()) {
            this._visitables.get("labels").add(builder);
        } else {
            this._visitables.get("labels").set(index, builder);
        }
        if (index < 0 || index >= this.labels.size()) {
            this.labels.add(builder);
        } else {
            this.labels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(LabelSelector ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLabels(Collection<LabelSelector> items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(LabelSelector ... items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLabels(Collection<LabelSelector> items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLabels(Predicate<LabelSelectorBuilder> predicate) {
        if (this.labels == null) {
            return (A)this;
        }
        Iterator<LabelSelectorBuilder> each = this.labels.iterator();
        Object visitables = this._visitables.get("labels");
        while (each.hasNext()) {
            LabelSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LabelSelector> getLabels() {
        return this.labels != null ? UserRestrictionFluentImpl.build(this.labels) : null;
    }

    @Override
    public List<LabelSelector> buildLabels() {
        return this.labels != null ? UserRestrictionFluentImpl.build(this.labels) : null;
    }

    @Override
    public LabelSelector buildLabel(Integer index) {
        return this.labels.get(index).build();
    }

    @Override
    public LabelSelector buildFirstLabel() {
        return this.labels.get(0).build();
    }

    @Override
    public LabelSelector buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    @Override
    public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLabels(List<LabelSelector> labels) {
        if (this.labels != null) {
            this._visitables.get("labels").removeAll(this.labels);
        }
        if (labels != null) {
            this.labels = new ArrayList();
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        } else {
            this.labels = null;
        }
        return (A)this;
    }

    @Override
    public A withLabels(LabelSelector ... labels) {
        if (this.labels != null) {
            this.labels.clear();
        }
        if (labels != null) {
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> addNewLabel() {
        return new LabelsNestedImpl();
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> addNewLabelLike(LabelSelector item) {
        return new LabelsNestedImpl(-1, item);
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> setNewLabelLike(Integer index, LabelSelector item) {
        return new LabelsNestedImpl(index, item);
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editLabel(Integer index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public UserRestrictionFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.test(this.labels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public A addToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(Integer index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsers(List<String> users) {
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRestrictionFluentImpl that = (UserRestrictionFluentImpl)o;
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groups, this.labels, this.users, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.users != null && !this.users.isEmpty()) {
            sb.append("users:");
            sb.append(this.users + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class LabelsNestedImpl<N>
    extends LabelSelectorFluentImpl<UserRestrictionFluent.LabelsNested<N>>
    implements UserRestrictionFluent.LabelsNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;
        Integer index;

        LabelsNestedImpl(Integer index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserRestrictionFluentImpl.this.setToLabels(this.index, this.builder.build());
        }

        @Override
        public N endLabel() {
            return this.and();
        }
    }
}

