/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl;

public class ImageStreamSpecBuilder
extends ImageStreamSpecFluentImpl<ImageStreamSpecBuilder>
implements VisitableBuilder<ImageStreamSpec, ImageStreamSpecBuilder> {
    ImageStreamSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamSpecBuilder() {
        this(false);
    }

    public ImageStreamSpecBuilder(Boolean validationEnabled) {
        this(new ImageStreamSpec(), validationEnabled);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStreamSpec(), validationEnabled);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, ImageStreamSpec instance) {
        this(fluent, instance, false);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, ImageStreamSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withLookupPolicy(instance.getLookupPolicy());
        fluent.withTags(instance.getTags());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamSpecBuilder(ImageStreamSpec instance) {
        this(instance, (Boolean)false);
    }

    public ImageStreamSpecBuilder(ImageStreamSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withLookupPolicy(instance.getLookupPolicy());
        this.withTags(instance.getTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageStreamSpec build() {
        ImageStreamSpec buildable = new ImageStreamSpec(this.fluent.getDockerImageRepository(), this.fluent.getLookupPolicy(), this.fluent.getTags());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

