/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ExternalMetricStatusFluentImpl<A extends ExternalMetricStatusFluent<A>>
extends BaseFluent<A>
implements ExternalMetricStatusFluent<A> {
    private Quantity currentAverageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private Map<String, Object> additionalProperties;

    public ExternalMetricStatusFluentImpl() {
    }

    public ExternalMetricStatusFluentImpl(ExternalMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    @Override
    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public A withCurrentValue(Quantity currentValue) {
        this.currentValue = currentValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    @Override
    public A withNewCurrentValue(String amount, String format) {
        return this.withCurrentValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentValue(String amount) {
        return this.withCurrentValue(new Quantity(amount));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        } else {
            this.metricSelector = null;
            this._visitables.get("metricSelector").remove(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricStatusFluentImpl that = (ExternalMetricStatusFluentImpl)o;
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals(that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        if (this.currentValue != null ? !this.currentValue.equals(that.currentValue) : that.currentValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.metricSelector != null ? !this.metricSelector.equals(that.metricSelector) : that.metricSelector != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.currentValue, this.metricName, this.metricSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentAverageValue != null) {
            sb.append("currentAverageValue:");
            sb.append(this.currentAverageValue + ",");
        }
        if (this.currentValue != null) {
            sb.append("currentValue:");
            sb.append(this.currentValue + ",");
        }
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.metricSelector != null) {
            sb.append("metricSelector:");
            sb.append(this.metricSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetricSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ExternalMetricStatusFluent.MetricSelectorNested<N>>
    implements ExternalMetricStatusFluent.MetricSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricStatusFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

