/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ComponentRouteSpec;
import io.fabric8.openshift.api.model.ComponentRouteSpecBuilder;
import io.fabric8.openshift.api.model.ComponentRouteSpecFluentImpl;
import io.fabric8.openshift.api.model.IngressSpec;
import io.fabric8.openshift.api.model.IngressSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private String appsDomain;
    private List<ComponentRouteSpecBuilder> componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
    private String domain;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withAppsDomain(instance.getAppsDomain());
        this.withComponentRoutes(instance.getComponentRoutes());
        this.withDomain(instance.getDomain());
    }

    @Override
    public String getAppsDomain() {
        return this.appsDomain;
    }

    @Override
    public A withAppsDomain(String appsDomain) {
        this.appsDomain = appsDomain;
        return (A)this;
    }

    @Override
    public Boolean hasAppsDomain() {
        return this.appsDomain != null;
    }

    @Override
    @Deprecated
    public A withNewAppsDomain(String arg0) {
        return this.withAppsDomain(new String(arg0));
    }

    @Override
    public A addToComponentRoutes(Integer index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        this._visitables.get("componentRoutes").add(index >= 0 ? index.intValue() : this._visitables.get("componentRoutes").size(), builder);
        this.componentRoutes.add(index >= 0 ? index.intValue() : this.componentRoutes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToComponentRoutes(Integer index, ComponentRouteSpec item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("componentRoutes").size()) {
            this._visitables.get("componentRoutes").add(builder);
        } else {
            this._visitables.get("componentRoutes").set(index, builder);
        }
        if (index < 0 || index >= this.componentRoutes.size()) {
            this.componentRoutes.add(builder);
        } else {
            this.componentRoutes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToComponentRoutes(ComponentRouteSpec ... items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get("componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToComponentRoutes(Collection<ComponentRouteSpec> items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
        }
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get("componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponentRoutes(ComponentRouteSpec ... items) {
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get("componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComponentRoutes(Collection<ComponentRouteSpec> items) {
        for (ComponentRouteSpec item : items) {
            ComponentRouteSpecBuilder builder = new ComponentRouteSpecBuilder(item);
            this._visitables.get("componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteSpecBuilder> predicate) {
        if (this.componentRoutes == null) {
            return (A)this;
        }
        Iterator<ComponentRouteSpecBuilder> each = this.componentRoutes.iterator();
        Object visitables = this._visitables.get("componentRoutes");
        while (each.hasNext()) {
            ComponentRouteSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComponentRouteSpec> getComponentRoutes() {
        return IngressSpecFluentImpl.build(this.componentRoutes);
    }

    @Override
    public List<ComponentRouteSpec> buildComponentRoutes() {
        return IngressSpecFluentImpl.build(this.componentRoutes);
    }

    @Override
    public ComponentRouteSpec buildComponentRoute(Integer index) {
        return this.componentRoutes.get(index).build();
    }

    @Override
    public ComponentRouteSpec buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    @Override
    public ComponentRouteSpec buildLastComponentRoute() {
        return this.componentRoutes.get(this.componentRoutes.size() - 1).build();
    }

    @Override
    public ComponentRouteSpec buildMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        for (ComponentRouteSpecBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComponentRoutes(List<ComponentRouteSpec> componentRoutes) {
        if (this.componentRoutes != null) {
            this._visitables.get("componentRoutes").removeAll(this.componentRoutes);
        }
        if (componentRoutes != null) {
            this.componentRoutes = new ArrayList<ComponentRouteSpecBuilder>();
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        } else {
            this.componentRoutes = null;
        }
        return (A)this;
    }

    @Override
    public A withComponentRoutes(ComponentRouteSpec ... componentRoutes) {
        if (this.componentRoutes != null) {
            this.componentRoutes.clear();
        }
        if (componentRoutes != null) {
            for (ComponentRouteSpec item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComponentRoutes() {
        return this.componentRoutes != null && !this.componentRoutes.isEmpty();
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRoute() {
        return new ComponentRoutesNestedImpl();
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteSpec item) {
        return new ComponentRoutesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> setNewComponentRouteLike(Integer index, ComponentRouteSpec item) {
        return new ComponentRoutesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editComponentRoute(Integer index) {
        if (this.componentRoutes.size() <= index) {
            throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editFirstComponentRoute() {
        if (this.componentRoutes.size() == 0) {
            throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(0, this.buildComponentRoute(0));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editLastComponentRoute() {
        int index = this.componentRoutes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressSpecFluent.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.componentRoutes.size(); ++i) {
            if (!predicate.test(this.componentRoutes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    @Deprecated
    public A withNewDomain(String arg0) {
        return this.withDomain(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.appsDomain != null ? !this.appsDomain.equals(that.appsDomain) : that.appsDomain != null) {
            return false;
        }
        if (this.componentRoutes != null ? !this.componentRoutes.equals(that.componentRoutes) : that.componentRoutes != null) {
            return false;
        }
        return !(this.domain != null ? !this.domain.equals(that.domain) : that.domain != null);
    }

    public int hashCode() {
        return Objects.hash(this.appsDomain, this.componentRoutes, this.domain, super.hashCode());
    }

    public class ComponentRoutesNestedImpl<N>
    extends ComponentRouteSpecFluentImpl<IngressSpecFluent.ComponentRoutesNested<N>>
    implements IngressSpecFluent.ComponentRoutesNested<N>,
    Nested<N> {
        ComponentRouteSpecBuilder builder;
        Integer index;

        ComponentRoutesNestedImpl(Integer index, ComponentRouteSpec item) {
            this.index = index;
            this.builder = new ComponentRouteSpecBuilder(this, item);
        }

        ComponentRoutesNestedImpl() {
            this.index = -1;
            this.builder = new ComponentRouteSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToComponentRoutes(this.index, this.builder.build());
        }

        @Override
        public N endComponentRoute() {
            return this.and();
        }
    }
}

