/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluentImpl;
import java.util.Objects;

public class ReplicationControllerBuilder
extends ReplicationControllerFluentImpl<ReplicationControllerBuilder>
implements VisitableBuilder<ReplicationController, ReplicationControllerBuilder> {
    ReplicationControllerFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerBuilder() {
        this(false);
    }

    public ReplicationControllerBuilder(Boolean validationEnabled) {
        this(new ReplicationController(), validationEnabled);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicationController(), validationEnabled);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, ReplicationController instance) {
        this(fluent, instance, false);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, ReplicationController instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerBuilder(ReplicationController instance) {
        this(instance, (Boolean)false);
    }

    public ReplicationControllerBuilder(ReplicationController instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicationController build() {
        ReplicationController buildable = new ReplicationController(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerBuilder that = (ReplicationControllerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

