/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.EnableOpenShiftMockClient;
import io.fabric8.openshift.client.server.mock.OpenShiftMockServer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenShiftMockServerExtension
extends KubernetesMockServerExtension {
    private OpenShiftMockServer openShiftMockServer;
    private NamespacedOpenShiftClient openShiftClient;

    @Override
    protected void destroy() {
        this.openShiftMockServer.destroy();
        this.openShiftClient.close();
    }

    @Override
    protected Class<?> getClientType() {
        return OpenShiftClient.class;
    }

    @Override
    protected Class<?> getKubernetesMockServerType() {
        return OpenShiftMockServer.class;
    }

    @Override
    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableOpenShiftMockClient a = testClass.getAnnotation(EnableOpenShiftMockClient.class);
        this.openShiftMockServer = a.crud() ? new OpenShiftMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(Collections.emptyList()), a.https()) : new OpenShiftMockServer(a.https());
        this.openShiftMockServer.init();
        this.openShiftClient = this.openShiftMockServer.createOpenShiftClient();
    }

    @Override
    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.openShiftClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.openShiftMockServer));
    }
}

