/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamListFluentImpl<A extends ImageStreamListFluent<A>>
extends BaseFluent<A>
implements ImageStreamListFluent<A> {
    private String apiVersion;
    private List<ImageStreamBuilder> items = new ArrayList<ImageStreamBuilder>();
    private String kind;
    private ListMeta metadata;

    public ImageStreamListFluentImpl() {
    }

    public ImageStreamListFluentImpl(ImageStreamList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, ImageStream item) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        ImageStreamBuilder builder = new ImageStreamBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, ImageStream item) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        ImageStreamBuilder builder = new ImageStreamBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ImageStream ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ImageStream> items) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ImageStream ... items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ImageStream> items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ImageStreamBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ImageStreamBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ImageStreamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageStream> getItems() {
        return ImageStreamListFluentImpl.build(this.items);
    }

    @Override
    public List<ImageStream> buildItems() {
        return ImageStreamListFluentImpl.build(this.items);
    }

    @Override
    public ImageStream buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public ImageStream buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ImageStream buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ImageStream buildMatchingItem(Predicate<ImageStreamBuilder> predicate) {
        for (ImageStreamBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ImageStreamBuilder> predicate) {
        for (ImageStreamBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ImageStream> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ImageStreamBuilder>();
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ImageStream ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> addNewItemLike(ImageStream item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> setNewItemLike(Integer index, ImageStream item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageStreamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamListFluentImpl that = (ImageStreamListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ImageStreamFluentImpl<ImageStreamListFluent.ItemsNested<N>>
    implements ImageStreamListFluent.ItemsNested<N>,
    Nested<N> {
        ImageStreamBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, ImageStream item) {
            this.index = index;
            this.builder = new ImageStreamBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ImageStreamBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

