/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.NetworkStatus;
import io.fabric8.openshift.api.model.operator.v1.NetworkStatusFluent;
import io.fabric8.openshift.api.model.operator.v1.NetworkStatusFluentImpl;
import java.util.Objects;

public class NetworkStatusBuilder
extends NetworkStatusFluentImpl<NetworkStatusBuilder>
implements VisitableBuilder<NetworkStatus, NetworkStatusBuilder> {
    NetworkStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkStatusBuilder() {
        this(false);
    }

    public NetworkStatusBuilder(Boolean validationEnabled) {
        this(new NetworkStatus(), validationEnabled);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkStatus(), validationEnabled);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, NetworkStatus instance) {
        this(fluent, instance, false);
    }

    public NetworkStatusBuilder(NetworkStatusFluent<?> fluent, NetworkStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withGenerations(instance.getGenerations());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public NetworkStatusBuilder(NetworkStatus instance) {
        this(instance, (Boolean)false);
    }

    public NetworkStatusBuilder(NetworkStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withGenerations(instance.getGenerations());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkStatus build() {
        NetworkStatus buildable = new NetworkStatus(this.fluent.getConditions(), this.fluent.getGenerations(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkStatusBuilder that = (NetworkStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

