/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetBuilder;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluentImpl;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetList;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodDisruptionBudgetListFluentImpl<A extends PodDisruptionBudgetListFluent<A>>
extends BaseFluent<A>
implements PodDisruptionBudgetListFluent<A> {
    private String apiVersion;
    private List<PodDisruptionBudgetBuilder> items = new ArrayList<PodDisruptionBudgetBuilder>();
    private String kind;
    private ListMeta metadata;

    public PodDisruptionBudgetListFluentImpl() {
    }

    public PodDisruptionBudgetListFluentImpl(PodDisruptionBudgetList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, PodDisruptionBudget item) {
        if (this.items == null) {
            this.items = new ArrayList<PodDisruptionBudgetBuilder>();
        }
        PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, PodDisruptionBudget item) {
        if (this.items == null) {
            this.items = new ArrayList<PodDisruptionBudgetBuilder>();
        }
        PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(PodDisruptionBudget ... items) {
        if (this.items == null) {
            this.items = new ArrayList<PodDisruptionBudgetBuilder>();
        }
        for (PodDisruptionBudget item : items) {
            PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<PodDisruptionBudget> items) {
        if (this.items == null) {
            this.items = new ArrayList<PodDisruptionBudgetBuilder>();
        }
        for (PodDisruptionBudget item : items) {
            PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PodDisruptionBudget ... items) {
        for (PodDisruptionBudget item : items) {
            PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<PodDisruptionBudget> items) {
        for (PodDisruptionBudget item : items) {
            PodDisruptionBudgetBuilder builder = new PodDisruptionBudgetBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<PodDisruptionBudgetBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<PodDisruptionBudgetBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            PodDisruptionBudgetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodDisruptionBudget> getItems() {
        return PodDisruptionBudgetListFluentImpl.build(this.items);
    }

    @Override
    public List<PodDisruptionBudget> buildItems() {
        return PodDisruptionBudgetListFluentImpl.build(this.items);
    }

    @Override
    public PodDisruptionBudget buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public PodDisruptionBudget buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public PodDisruptionBudget buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public PodDisruptionBudget buildMatchingItem(Predicate<PodDisruptionBudgetBuilder> predicate) {
        for (PodDisruptionBudgetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<PodDisruptionBudgetBuilder> predicate) {
        for (PodDisruptionBudgetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<PodDisruptionBudget> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<PodDisruptionBudgetBuilder>();
            for (PodDisruptionBudget item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(PodDisruptionBudget ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (PodDisruptionBudget item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> addNewItemLike(PodDisruptionBudget item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> setNewItemLike(Integer index, PodDisruptionBudget item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public PodDisruptionBudgetListFluent.ItemsNested<A> editMatchingItem(Predicate<PodDisruptionBudgetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodDisruptionBudgetListFluentImpl that = (PodDisruptionBudgetListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends PodDisruptionBudgetFluentImpl<PodDisruptionBudgetListFluent.ItemsNested<N>>
    implements PodDisruptionBudgetListFluent.ItemsNested<N>,
    Nested<N> {
        PodDisruptionBudgetBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, PodDisruptionBudget item) {
            this.index = index;
            this.builder = new PodDisruptionBudgetBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new PodDisruptionBudgetBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodDisruptionBudgetListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

