/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule;
import io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleFluent;
import io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleFluentImpl;
import java.util.Objects;

public class NonResourceRuleBuilder
extends NonResourceRuleFluentImpl<NonResourceRuleBuilder>
implements VisitableBuilder<NonResourceRule, NonResourceRuleBuilder> {
    NonResourceRuleFluent<?> fluent;
    Boolean validationEnabled;

    public NonResourceRuleBuilder() {
        this(false);
    }

    public NonResourceRuleBuilder(Boolean validationEnabled) {
        this(new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, NonResourceRule instance) {
        this(fluent, instance, false);
    }

    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent, NonResourceRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public NonResourceRuleBuilder(NonResourceRule instance) {
        this(instance, (Boolean)false);
    }

    public NonResourceRuleBuilder(NonResourceRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NonResourceRule build() {
        NonResourceRule buildable = new NonResourceRule(this.fluent.getNonResourceURLs(), this.fluent.getVerbs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonResourceRuleBuilder that = (NonResourceRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

