/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl;
import java.util.Objects;

public class LoadBalancerIngressBuilder
extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder>
implements VisitableBuilder<LoadBalancerIngress, LoadBalancerIngressBuilder> {
    LoadBalancerIngressFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerIngressBuilder() {
        this(false);
    }

    public LoadBalancerIngressBuilder(Boolean validationEnabled) {
        this(new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LoadBalancerIngress(), validationEnabled);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance) {
        this(fluent, instance, false);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent, LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        fluent.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance) {
        this(instance, (Boolean)false);
    }

    public LoadBalancerIngressBuilder(LoadBalancerIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public LoadBalancerIngress build() {
        LoadBalancerIngress buildable = new LoadBalancerIngress(this.fluent.getHostname(), this.fluent.getIp(), this.fluent.getPorts());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

