/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl;
import java.util.Objects;

public class ImageStreamSpecBuilder
extends ImageStreamSpecFluentImpl<ImageStreamSpecBuilder>
implements VisitableBuilder<ImageStreamSpec, ImageStreamSpecBuilder> {
    ImageStreamSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamSpecBuilder() {
        this(true);
    }

    public ImageStreamSpecBuilder(Boolean validationEnabled) {
        this(new ImageStreamSpec(), validationEnabled);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStreamSpec(), validationEnabled);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, ImageStreamSpec instance) {
        this(fluent, instance, true);
    }

    public ImageStreamSpecBuilder(ImageStreamSpecFluent<?> fluent, ImageStreamSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withLookupPolicy(instance.getLookupPolicy());
        fluent.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamSpecBuilder(ImageStreamSpec instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamSpecBuilder(ImageStreamSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withLookupPolicy(instance.getLookupPolicy());
        this.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageStreamSpec build() {
        ImageStreamSpec buildable = new ImageStreamSpec(this.fluent.getDockerImageRepository(), this.fluent.getLookupPolicy(), this.fluent.getTags());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamSpecBuilder that = (ImageStreamSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

