/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ComponentRouteSpec;
import io.fabric8.openshift.api.model.ComponentRouteSpecFluent;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl;
import java.util.Objects;

public class ComponentRouteSpecFluentImpl<A extends ComponentRouteSpecFluent<A>>
extends BaseFluent<A>
implements ComponentRouteSpecFluent<A> {
    private String hostname;
    private String name;
    private String namespace;
    private SecretNameReferenceBuilder servingCertKeyPairSecret;

    public ComponentRouteSpecFluentImpl() {
    }

    public ComponentRouteSpecFluentImpl(ComponentRouteSpec instance) {
        this.withHostname(instance.getHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String arg0) {
        return this.withHostname(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public A withNewNamespace(String arg0) {
        return this.withNamespace(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretNameReference getServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null ? this.servingCertKeyPairSecret.build() : null;
    }

    @Override
    public SecretNameReference buildServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null ? this.servingCertKeyPairSecret.build() : null;
    }

    @Override
    public A withServingCertKeyPairSecret(SecretNameReference servingCertKeyPairSecret) {
        this._visitables.get("servingCertKeyPairSecret").remove(this.servingCertKeyPairSecret);
        if (servingCertKeyPairSecret != null) {
            this.servingCertKeyPairSecret = new SecretNameReferenceBuilder(servingCertKeyPairSecret);
            this._visitables.get("servingCertKeyPairSecret").add(this.servingCertKeyPairSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServingCertKeyPairSecret() {
        return this.servingCertKeyPairSecret != null;
    }

    @Override
    public A withNewServingCertKeyPairSecret(String name) {
        return this.withServingCertKeyPairSecret(new SecretNameReference(name));
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecret() {
        return new ServingCertKeyPairSecretNestedImpl();
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return new ServingCertKeyPairSecretNestedImpl(item);
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret());
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecret() {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret() != null ? this.getServingCertKeyPairSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecretLike(SecretNameReference item) {
        return this.withNewServingCertKeyPairSecretLike(this.getServingCertKeyPairSecret() != null ? this.getServingCertKeyPairSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentRouteSpecFluentImpl that = (ComponentRouteSpecFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.servingCertKeyPairSecret != null ? !this.servingCertKeyPairSecret.equals(that.servingCertKeyPairSecret) : that.servingCertKeyPairSecret != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.name, this.namespace, this.servingCertKeyPairSecret, super.hashCode());
    }

    public class ServingCertKeyPairSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<N>>
    implements ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<N>,
    Nested<N> {
        private final SecretNameReferenceBuilder builder;

        ServingCertKeyPairSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ServingCertKeyPairSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentRouteSpecFluentImpl.this.withServingCertKeyPairSecret(this.builder.build());
        }

        @Override
        public N endServingCertKeyPairSecret() {
            return this.and();
        }
    }
}

