/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.ResourceHandlerImpl;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import okhttp3.OkHttpClient;

public final class Handlers {
    private static final Map<Class<?>, ResourceHandler<?, ?>> RESOURCE_HANDLER_MAP = new ConcurrentHashMap();

    private Handlers() {
    }

    public static <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> void register(Class<T> type, BiFunction<OkHttpClient, Config, HasMetadataOperation<T, L, R>> operationConstructor) {
        if (RESOURCE_HANDLER_MAP.put(type, new ResourceHandlerImpl(type, operationConstructor)) != null) {
            throw new AssertionError((Object)String.format("%s already registered", type.getName()));
        }
    }

    public static <T extends HasMetadata> void unregister(Class<T> type) {
        RESOURCE_HANDLER_MAP.remove(type);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(T meta) {
        return Handlers.get(meta.getClass());
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(Class<T> type) {
        if (type.equals(GenericKubernetesResource.class)) {
            return null;
        }
        return RESOURCE_HANDLER_MAP.computeIfAbsent(type, k -> new ResourceHandlerImpl(type, null));
    }

    public static <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> HasMetadataOperation<T, L, R> getOperation(Class<T> type, Class<L> listType, OkHttpClient client, Config config) {
        ResourceHandler resourceHandler = Handlers.get(type);
        return resourceHandler.operation(client, config, listType);
    }

    public static <T extends HasMetadata> HasMetadataOperation<T, ?, Resource<T>> getNonListingOperation(Class<T> type, OkHttpClient client, Config config) {
        return Handlers.getOperation(type, KubernetesResourceUtil.inferListType(type), client, config);
    }

    public static <T extends HasMetadata> boolean shouldRegister(Class<T> type) {
        ResourceHandler<?, ?> handler = RESOURCE_HANDLER_MAP.get(type);
        return !RESOURCE_HANDLER_MAP.isEmpty() && (handler == null || !handler.hasOperation());
    }

    public static <T extends HasMetadata> NamespacedInOutCreateable<T, T> getNamespacedHasMetadataCreateOnlyOperation(Class<T> type, OkHttpClient client, Config config) {
        HasMetadataOperation<T, ?, Resource<T>> operation = Handlers.getNonListingOperation(type, client, config);
        return operation::inNamespace;
    }
}

