/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfigList;
import io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigList;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigList;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPool;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.ContainerRuntimeConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.ControllerConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.KubeletConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigPoolOperationsImpl;
import okhttp3.OkHttpClient;

public class OpenShiftMachineConfigurationAPIGroupClient
extends BaseClient
implements MachineConfigurationAPIGroupDSL {
    public OpenShiftMachineConfigurationAPIGroupClient() {
    }

    public OpenShiftMachineConfigurationAPIGroupClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<ContainerRuntimeConfig, ContainerRuntimeConfigList, Resource<ContainerRuntimeConfig>> containerRuntimeConfigs() {
        return new ContainerRuntimeConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ControllerConfig, ControllerConfigList, Resource<ControllerConfig>> controllerConfigs() {
        return new ControllerConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<KubeletConfig, KubeletConfigList, Resource<KubeletConfig>> kubeletConfigs() {
        return new KubeletConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<MachineConfigPool, MachineConfigPoolList, Resource<MachineConfigPool>> machineConfigPools() {
        return new MachineConfigPoolOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<MachineConfig, MachineConfigList, Resource<MachineConfig>> machineConfigs() {
        return new MachineConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }
}

