/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.OpsGenieConfigResponderFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OpsGenieConfigFluentImpl<A extends OpsGenieConfigFluent<A>>
extends BaseFluent<A>
implements OpsGenieConfigFluent<A> {
    private SecretKeySelector apiKey;
    private String apiURL;
    private String description;
    private List<KeyValueBuilder> details = new ArrayList<KeyValueBuilder>();
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String note;
    private String priority;
    private List<OpsGenieConfigResponderBuilder> responders = new ArrayList<OpsGenieConfigResponderBuilder>();
    private Boolean sendResolved;
    private String source;
    private String tags;

    public OpsGenieConfigFluentImpl() {
    }

    public OpsGenieConfigFluentImpl(OpsGenieConfig instance) {
        this.withApiKey(instance.getApiKey());
        this.withApiURL(instance.getApiURL());
        this.withDescription(instance.getDescription());
        this.withDetails(instance.getDetails());
        this.withHttpConfig(instance.getHttpConfig());
        this.withMessage(instance.getMessage());
        this.withNote(instance.getNote());
        this.withPriority(instance.getPriority());
        this.withResponders(instance.getResponders());
        this.withSendResolved(instance.getSendResolved());
        this.withSource(instance.getSource());
        this.withTags(instance.getTags());
    }

    @Override
    public SecretKeySelector getApiKey() {
        return this.apiKey;
    }

    @Override
    public A withApiKey(SecretKeySelector apiKey) {
        this.apiKey = apiKey;
        return (A)this;
    }

    @Override
    public Boolean hasApiKey() {
        return this.apiKey != null;
    }

    @Override
    public A withNewApiKey(String key, String name, Boolean optional) {
        return this.withApiKey(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getApiURL() {
        return this.apiURL;
    }

    @Override
    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)this;
    }

    @Override
    public Boolean hasApiURL() {
        return this.apiURL != null;
    }

    @Override
    @Deprecated
    public A withNewApiURL(String arg0) {
        return this.withApiURL(new String(arg0));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    @Deprecated
    public A withNewDescription(String arg0) {
        return this.withDescription(new String(arg0));
    }

    @Override
    public A addToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList<KeyValueBuilder>();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        this._visitables.get("details").add(index >= 0 ? index : this._visitables.get("details").size(), builder);
        this.details.add(index >= 0 ? index : this.details.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDetails(int index, KeyValue item) {
        if (this.details == null) {
            this.details = new ArrayList<KeyValueBuilder>();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this._visitables.get("details").size()) {
            this._visitables.get("details").add(builder);
        } else {
            this._visitables.get("details").set(index, builder);
        }
        if (index < 0 || index >= this.details.size()) {
            this.details.add(builder);
        } else {
            this.details.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDetails(KeyValue ... items) {
        if (this.details == null) {
            this.details = new ArrayList<KeyValueBuilder>();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDetails(Collection<KeyValue> items) {
        if (this.details == null) {
            this.details = new ArrayList<KeyValueBuilder>();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("details").add(builder);
            this.details.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDetails(KeyValue ... items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDetails(Collection<KeyValue> items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("details").remove(builder);
            if (this.details == null) continue;
            this.details.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
        if (this.details == null) {
            return (A)this;
        }
        Iterator<KeyValueBuilder> each = this.details.iterator();
        Object visitables = this._visitables.get("details");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyValue> getDetails() {
        return OpsGenieConfigFluentImpl.build(this.details);
    }

    @Override
    public List<KeyValue> buildDetails() {
        return OpsGenieConfigFluentImpl.build(this.details);
    }

    @Override
    public KeyValue buildDetail(int index) {
        return this.details.get(index).build();
    }

    @Override
    public KeyValue buildFirstDetail() {
        return this.details.get(0).build();
    }

    @Override
    public KeyValue buildLastDetail() {
        return this.details.get(this.details.size() - 1).build();
    }

    @Override
    public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.details) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDetails(List<KeyValue> details) {
        if (this.details != null) {
            this._visitables.get("details").removeAll(this.details);
        }
        if (details != null) {
            this.details = new ArrayList<KeyValueBuilder>();
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        } else {
            this.details = null;
        }
        return (A)this;
    }

    @Override
    public A withDetails(KeyValue ... details) {
        if (this.details != null) {
            this.details.clear();
        }
        if (details != null) {
            for (KeyValue item : details) {
                this.addToDetails(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    @Override
    public A addNewDetail(String key, String value) {
        return this.addToDetails(new KeyValue(key, value));
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> addNewDetail() {
        return new DetailsNestedImpl();
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> addNewDetailLike(KeyValue item) {
        return new DetailsNestedImpl(-1, item);
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> setNewDetailLike(int index, KeyValue item) {
        return new DetailsNestedImpl(index, item);
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> editDetail(int index) {
        if (this.details.size() <= index) {
            throw new RuntimeException("Can't edit details. Index exceeds size.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> editFirstDetail() {
        if (this.details.size() == 0) {
            throw new RuntimeException("Can't edit first details. The list is empty.");
        }
        return this.setNewDetailLike(0, this.buildDetail(0));
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> editLastDetail() {
        int index = this.details.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last details. The list is empty.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    public OpsGenieConfigFluent.DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.details.size(); ++i) {
            if (!predicate.test(this.details.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching details. No match found.");
        }
        return this.setNewDetailLike(index, this.buildDetail(index));
    }

    @Override
    @Deprecated
    public HTTPConfig getHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    @Override
    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get("httpConfig").remove(this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    @Override
    public OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNestedImpl();
    }

    @Override
    public OpsGenieConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNestedImpl(item);
    }

    @Override
    public OpsGenieConfigFluent.HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig());
    }

    @Override
    public OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : new HTTPConfigBuilder().build());
    }

    @Override
    public OpsGenieConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(this.getHttpConfig() != null ? this.getHttpConfig() : item);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public A withNewMessage(String arg0) {
        return this.withMessage(new String(arg0));
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public A withNote(String note) {
        this.note = note;
        return (A)this;
    }

    @Override
    public Boolean hasNote() {
        return this.note != null;
    }

    @Override
    @Deprecated
    public A withNewNote(String arg0) {
        return this.withNote(new String(arg0));
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(String priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    @Deprecated
    public A withNewPriority(String arg0) {
        return this.withPriority(new String(arg0));
    }

    @Override
    public A addToResponders(int index, OpsGenieConfigResponder item) {
        if (this.responders == null) {
            this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();
        }
        OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
        this._visitables.get("responders").add(index >= 0 ? index : this._visitables.get("responders").size(), builder);
        this.responders.add(index >= 0 ? index : this.responders.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResponders(int index, OpsGenieConfigResponder item) {
        if (this.responders == null) {
            this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();
        }
        OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
        if (index < 0 || index >= this._visitables.get("responders").size()) {
            this._visitables.get("responders").add(builder);
        } else {
            this._visitables.get("responders").set(index, builder);
        }
        if (index < 0 || index >= this.responders.size()) {
            this.responders.add(builder);
        } else {
            this.responders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResponders(OpsGenieConfigResponder ... items) {
        if (this.responders == null) {
            this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get("responders").add(builder);
            this.responders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResponders(Collection<OpsGenieConfigResponder> items) {
        if (this.responders == null) {
            this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();
        }
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get("responders").add(builder);
            this.responders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResponders(OpsGenieConfigResponder ... items) {
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get("responders").remove(builder);
            if (this.responders == null) continue;
            this.responders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResponders(Collection<OpsGenieConfigResponder> items) {
        for (OpsGenieConfigResponder item : items) {
            OpsGenieConfigResponderBuilder builder = new OpsGenieConfigResponderBuilder(item);
            this._visitables.get("responders").remove(builder);
            if (this.responders == null) continue;
            this.responders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResponders(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        if (this.responders == null) {
            return (A)this;
        }
        Iterator<OpsGenieConfigResponderBuilder> each = this.responders.iterator();
        Object visitables = this._visitables.get("responders");
        while (each.hasNext()) {
            OpsGenieConfigResponderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OpsGenieConfigResponder> getResponders() {
        return OpsGenieConfigFluentImpl.build(this.responders);
    }

    @Override
    public List<OpsGenieConfigResponder> buildResponders() {
        return OpsGenieConfigFluentImpl.build(this.responders);
    }

    @Override
    public OpsGenieConfigResponder buildResponder(int index) {
        return this.responders.get(index).build();
    }

    @Override
    public OpsGenieConfigResponder buildFirstResponder() {
        return this.responders.get(0).build();
    }

    @Override
    public OpsGenieConfigResponder buildLastResponder() {
        return this.responders.get(this.responders.size() - 1).build();
    }

    @Override
    public OpsGenieConfigResponder buildMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        for (OpsGenieConfigResponderBuilder item : this.responders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        for (OpsGenieConfigResponderBuilder item : this.responders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResponders(List<OpsGenieConfigResponder> responders) {
        if (this.responders != null) {
            this._visitables.get("responders").removeAll(this.responders);
        }
        if (responders != null) {
            this.responders = new ArrayList<OpsGenieConfigResponderBuilder>();
            for (OpsGenieConfigResponder item : responders) {
                this.addToResponders(item);
            }
        } else {
            this.responders = null;
        }
        return (A)this;
    }

    @Override
    public A withResponders(OpsGenieConfigResponder ... responders) {
        if (this.responders != null) {
            this.responders.clear();
        }
        if (responders != null) {
            for (OpsGenieConfigResponder item : responders) {
                this.addToResponders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponders() {
        return this.responders != null && !this.responders.isEmpty();
    }

    @Override
    public A addNewResponder(String id, String name, String type, String username) {
        return this.addToResponders(new OpsGenieConfigResponder(id, name, type, username));
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> addNewResponder() {
        return new RespondersNestedImpl();
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> addNewResponderLike(OpsGenieConfigResponder item) {
        return new RespondersNestedImpl(-1, item);
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> setNewResponderLike(int index, OpsGenieConfigResponder item) {
        return new RespondersNestedImpl(index, item);
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> editResponder(int index) {
        if (this.responders.size() <= index) {
            throw new RuntimeException("Can't edit responders. Index exceeds size.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> editFirstResponder() {
        if (this.responders.size() == 0) {
            throw new RuntimeException("Can't edit first responders. The list is empty.");
        }
        return this.setNewResponderLike(0, this.buildResponder(0));
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> editLastResponder() {
        int index = this.responders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last responders. The list is empty.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    @Override
    public OpsGenieConfigFluent.RespondersNested<A> editMatchingResponder(Predicate<OpsGenieConfigResponderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.responders.size(); ++i) {
            if (!predicate.test(this.responders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching responders. No match found.");
        }
        return this.setNewResponderLike(index, this.buildResponder(index));
    }

    @Override
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @Override
    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    @Override
    public Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public A withSource(String source) {
        this.source = source;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    @Deprecated
    public A withNewSource(String arg0) {
        return this.withSource(new String(arg0));
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public A withTags(String tags) {
        this.tags = tags;
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null;
    }

    @Override
    @Deprecated
    public A withNewTags(String arg0) {
        return this.withTags(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpsGenieConfigFluentImpl that = (OpsGenieConfigFluentImpl)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.apiURL != null ? !this.apiURL.equals(that.apiURL) : that.apiURL != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.responders != null ? !this.responders.equals(that.responders) : that.responders != null) {
            return false;
        }
        if (this.sendResolved != null ? !this.sendResolved.equals(that.sendResolved) : that.sendResolved != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.apiURL, this.description, this.details, this.httpConfig, this.message, this.note, this.priority, this.responders, this.sendResolved, this.source, this.tags, super.hashCode());
    }

    public class RespondersNestedImpl<N>
    extends OpsGenieConfigResponderFluentImpl<OpsGenieConfigFluent.RespondersNested<N>>
    implements OpsGenieConfigFluent.RespondersNested<N>,
    Nested<N> {
        private final OpsGenieConfigResponderBuilder builder;
        private final int index;

        RespondersNestedImpl(int index, OpsGenieConfigResponder item) {
            this.index = index;
            this.builder = new OpsGenieConfigResponderBuilder(this, item);
        }

        RespondersNestedImpl() {
            this.index = -1;
            this.builder = new OpsGenieConfigResponderBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpsGenieConfigFluentImpl.this.setToResponders(this.index, this.builder.build());
        }

        @Override
        public N endResponder() {
            return this.and();
        }
    }

    public class HttpConfigNestedImpl<N>
    extends HTTPConfigFluentImpl<OpsGenieConfigFluent.HttpConfigNested<N>>
    implements OpsGenieConfigFluent.HttpConfigNested<N>,
    Nested<N> {
        private final HTTPConfigBuilder builder;

        HttpConfigNestedImpl(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        HttpConfigNestedImpl() {
            this.builder = new HTTPConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpsGenieConfigFluentImpl.this.withHttpConfig(this.builder.build());
        }

        @Override
        public N endHttpConfig() {
            return this.and();
        }
    }

    public class DetailsNestedImpl<N>
    extends KeyValueFluentImpl<OpsGenieConfigFluent.DetailsNested<N>>
    implements OpsGenieConfigFluent.DetailsNested<N>,
    Nested<N> {
        private final KeyValueBuilder builder;
        private final int index;

        DetailsNestedImpl(int index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.index = -1;
            this.builder = new KeyValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpsGenieConfigFluentImpl.this.setToDetails(this.index, this.builder.build());
        }

        @Override
        public N endDetail() {
            return this.and();
        }
    }
}

