/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.CrossVersionObjectReference;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.CrossVersionObjectReferenceBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.CrossVersionObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpec;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerSpecFluent;
import java.util.Objects;

public class MachineAutoscalerSpecFluentImpl<A extends MachineAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements MachineAutoscalerSpecFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;

    public MachineAutoscalerSpecFluentImpl() {
    }

    public MachineAutoscalerSpecFluentImpl(MachineAutoscalerSpec instance) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public MachineAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public MachineAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public MachineAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public MachineAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public MachineAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineAutoscalerSpecFluentImpl that = (MachineAutoscalerSpecFluentImpl)o;
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        return !(this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.minReplicas, this.scaleTargetRef, super.hashCode());
    }

    public class ScaleTargetRefNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<MachineAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements MachineAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        private final CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

