/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceLimitsFluentImpl;
import java.util.Objects;

public class ResourceLimitsBuilder
extends ResourceLimitsFluentImpl<ResourceLimitsBuilder>
implements VisitableBuilder<ResourceLimits, ResourceLimitsBuilder> {
    ResourceLimitsFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceLimitsBuilder() {
        this(true);
    }

    public ResourceLimitsBuilder(Boolean validationEnabled) {
        this(new ResourceLimits(), validationEnabled);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceLimits(), validationEnabled);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, ResourceLimits instance) {
        this(fluent, instance, true);
    }

    public ResourceLimitsBuilder(ResourceLimitsFluent<?> fluent, ResourceLimits instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCores(instance.getCores());
        fluent.withGpus(instance.getGpus());
        fluent.withMaxNodesTotal(instance.getMaxNodesTotal());
        fluent.withMemory(instance.getMemory());
        this.validationEnabled = validationEnabled;
    }

    public ResourceLimitsBuilder(ResourceLimits instance) {
        this(instance, (Boolean)true);
    }

    public ResourceLimitsBuilder(ResourceLimits instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCores(instance.getCores());
        this.withGpus(instance.getGpus());
        this.withMaxNodesTotal(instance.getMaxNodesTotal());
        this.withMemory(instance.getMemory());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceLimits build() {
        ResourceLimits buildable = new ResourceLimits(this.fluent.getCores(), this.fluent.getGpus(), this.fluent.getMaxNodesTotal(), this.fluent.getMemory());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceLimitsBuilder that = (ResourceLimitsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

