/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.server.mock.FallbackHasMetadata;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.AttributeType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesAttributesExtractor
implements AttributeExtractor<HasMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesAttributesExtractor.class);
    public static final String KEY = "key";
    public static final String KIND = "kind";
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    public static final String VALUE = "value";
    private static final String API_GROUP = "/o?api(s/[a-zA-Z0-9-_.]+)?";
    private static final String VERSION_GROUP = "(/(?<version>[a-zA-Z0-9-_]+))?";
    private static final String KIND_GROUP = "/(?<kind>[^/?]+)";
    private static final String NAME_GROUP = "(/(?<name>[^/?]+))?";
    private static final String NAMESPACE_GROUP = "(/namespaces/(?<namespace>[^/]+))?";
    private static final String SUBRESOURCE_MAYBE_GROUP = "(/(status|scale))?";
    private static final String END_GROUP = "[^ /]*";
    protected static final Pattern PATTERN = Pattern.compile("/o?api(s/[a-zA-Z0-9-_.]+)?(/(?<version>[a-zA-Z0-9-_]+))?(/namespaces/(?<namespace>[^/]+))?/(?<kind>[^/?]+)(/(?<name>[^/?]+))?(/(status|scale))?[^ /]*");
    private static final String LABEL_KEY_PREFIX = "labels:";
    private static final String KEY_GROUP = "(?<key>[a-zA-Z0-9-_./]+)";
    private static final String EQUALITY_GROUP = "(==|(?<!!)=)";
    private static final String NOT_EQUALITY_GROUP = "(!=)";
    private static final String VALUE_GROUP = "(?<value>[a-zA-Z0-9-_.]+)";
    private static final Pattern LABEL_REQUIREMENT_EQUALITY = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)(==|(?<!!)=)(?<value>[a-zA-Z0-9-_.]+)");
    private static final Pattern LABEL_REQUIREMENT_NOT_EQUALITY = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)(!=)(?<value>[a-zA-Z0-9-_.]+)");
    private static final Pattern LABEL_REQUIREMENT_EXISTS = Pattern.compile("(?<key>[a-zA-Z0-9-_./]+)");
    private static final Pattern LABEL_REQUIREMENT_NOT_EXISTS = Pattern.compile("!(?<key>[a-zA-Z0-9-_./]+)");
    private static final String SCHEME = "http";
    private static final String HOST = "localhost";
    private List<CustomResourceDefinitionContext> crdContexts;

    public KubernetesAttributesExtractor() {
        this.crdContexts = Collections.emptyList();
    }

    public KubernetesAttributesExtractor(List<CustomResourceDefinitionContext> crdContexts) {
        this.crdContexts = crdContexts;
    }

    private HttpUrl parseUrlFromPathAndQuery(String s) {
        if (!s.startsWith("/")) {
            s = "/" + s;
        }
        return HttpUrl.parse((String)String.format("%s://%s%s", SCHEME, HOST, s));
    }

    public AttributeSet fromPath(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HttpUrl url = this.parseUrlFromPathAndQuery(s);
        Matcher m = PATTERN.matcher(url.encodedPath());
        if (m.matches()) {
            AttributeSet set = KubernetesAttributesExtractor.extract(m, this.crdContexts);
            set = AttributeSet.merge((AttributeSet[])new AttributeSet[]{set, KubernetesAttributesExtractor.extractQueryParameters(url)});
            LOGGER.debug("fromPath {} : {}", (Object)s, (Object)set);
            return set;
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet fromResource(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        return this.fromPath(s);
    }

    public AttributeSet extract(HasMetadata o) {
        AttributeSet attributes = this.extractMetadataAttributes(o);
        if (!Utils.isNullOrEmpty(o.getKind())) {
            attributes = attributes.add(new Attribute[]{new Attribute(KIND, o.getKind().toLowerCase(Locale.ROOT))});
        }
        return attributes;
    }

    protected AttributeSet extractMetadataAttributes(HasMetadata hasMetadata) {
        AttributeSet metadataAttributes = new AttributeSet(new Attribute[0]);
        if (!Utils.isNullOrEmpty(hasMetadata.getMetadata().getName())) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(NAME, hasMetadata.getMetadata().getName())});
        }
        if (!Utils.isNullOrEmpty(hasMetadata.getMetadata().getNamespace())) {
            metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(NAMESPACE, hasMetadata.getMetadata().getNamespace())});
        }
        if (hasMetadata.getMetadata().getLabels() != null) {
            for (Map.Entry<String, String> label : hasMetadata.getMetadata().getLabels().entrySet()) {
                metadataAttributes = metadataAttributes.add(new Attribute[]{new Attribute(LABEL_KEY_PREFIX + label.getKey(), label.getValue())});
            }
        }
        return metadataAttributes;
    }

    private static AttributeSet extract(Matcher m, List<CustomResourceDefinitionContext> crdContexts) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        if (m.matches()) {
            String namespace;
            String kind = m.group(KIND);
            if (!Utils.isNullOrEmpty(kind)) {
                kind = KubernetesAttributesExtractor.resolveKindFromPlural(crdContexts, kind);
                attributes = attributes.add(new Attribute[]{new Attribute(KIND, kind)});
            }
            if (!Utils.isNullOrEmpty(namespace = m.group(NAMESPACE))) {
                attributes = attributes.add(new Attribute[]{new Attribute(NAMESPACE, namespace)});
            }
            try {
                String name = m.group(NAME);
                if (!Utils.isNullOrEmpty(name)) {
                    attributes = attributes.add(new Attribute[]{new Attribute(NAME, name)});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return attributes;
    }

    private static String resolveKindFromPlural(List<CustomResourceDefinitionContext> crdContexts, String kind) {
        if (KubernetesAttributesExtractor.isCustomResourceKind(crdContexts, kind)) {
            return KubernetesAttributesExtractor.getCustomResourceKindFromPlural(crdContexts, kind);
        }
        return KubernetesAttributesExtractor.getKindFromPluralForKubernetesTypes(kind);
    }

    private static String getKindFromPluralForKubernetesTypes(String kind) {
        if (kind.endsWith("ses")) {
            kind = kind.substring(0, kind.length() - 2);
        } else if (kind.equalsIgnoreCase("PodSecurityPolicies") || kind.equalsIgnoreCase("NetworkPolicies")) {
            kind = kind.substring(0, kind.length() - 3) + "y";
        } else if (!kind.equalsIgnoreCase("securityContextConstraints") && !kind.equalsIgnoreCase("endpoints") && kind.endsWith("s")) {
            kind = kind.substring(0, kind.length() - 1);
        }
        return kind;
    }

    private static AttributeSet extractQueryParameters(HttpUrl url) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        String labelSelector = url.queryParameter("labelSelector");
        if (labelSelector != null) {
            for (String requirement : labelSelector.split(",")) {
                Attribute label = KubernetesAttributesExtractor.parseLabel(requirement);
                if (label != null) {
                    attributes = attributes.add(new Attribute[]{label});
                    continue;
                }
                LOGGER.warn("Ignoring unsupported label requirement: {}", (Object)requirement);
            }
        }
        return attributes;
    }

    private static Attribute parseLabel(String label) {
        Matcher m = LABEL_REQUIREMENT_EQUALITY.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), m.group(VALUE));
        }
        m = LABEL_REQUIREMENT_NOT_EQUALITY.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), m.group(VALUE), AttributeType.WITHOUT);
        }
        m = LABEL_REQUIREMENT_EXISTS.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), "", AttributeType.EXISTS);
        }
        m = LABEL_REQUIREMENT_NOT_EXISTS.matcher(label);
        if (m.matches()) {
            return new Attribute(LABEL_KEY_PREFIX + m.group(KEY), "", AttributeType.NOT_EXISTS);
        }
        return null;
    }

    static HasMetadata toKubernetesResource(String s) {
        HasMetadata hasMetadata;
        ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8.name()));
        try {
            hasMetadata = (HasMetadata)Serialization.unmarshal(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return KubernetesAttributesExtractor.toRawHasMetadata(s);
            }
        }
        ((InputStream)stream).close();
        return hasMetadata;
    }

    private static HasMetadata toRawHasMetadata(String s) {
        HasMetadata hasMetadata;
        ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8.name()));
        try {
            hasMetadata = (HasMetadata)Serialization.jsonMapper().readValue((InputStream)stream, FallbackHasMetadata.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        ((InputStream)stream).close();
        return hasMetadata;
    }

    private static boolean isCustomResourceKind(List<CustomResourceDefinitionContext> crdContexts, String kind) {
        return crdContexts.stream().anyMatch(c -> c.getPlural().equals(kind));
    }

    private static String getCustomResourceKindFromPlural(List<CustomResourceDefinitionContext> crdContexts, String kind) {
        CustomResourceDefinitionContext crdContext = crdContexts.stream().filter(c -> c.getPlural().equals(kind)).findAny().orElse(null);
        return crdContext != null && crdContext.getKind() != null ? crdContext.getKind().toLowerCase() : null;
    }
}

