/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.BootVolume;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.BootVolumeBuilder;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.BootVolumeFluentImpl;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHost;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHostBuilder;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.DedicatedHostFluentImpl;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.MachinePoolFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private BootVolumeBuilder bootVolume;
    private List<DedicatedHostBuilder> dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withBootVolume(instance.getBootVolume());
        this.withDedicatedHosts(instance.getDedicatedHosts());
        this.withType(instance.getType());
        this.withZones(instance.getZones());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public BootVolume getBootVolume() {
        return this.bootVolume != null ? this.bootVolume.build() : null;
    }

    @Override
    public BootVolume buildBootVolume() {
        return this.bootVolume != null ? this.bootVolume.build() : null;
    }

    @Override
    public A withBootVolume(BootVolume bootVolume) {
        this._visitables.get("bootVolume").remove(this.bootVolume);
        if (bootVolume != null) {
            this.bootVolume = new BootVolumeBuilder(bootVolume);
            this._visitables.get("bootVolume").add(this.bootVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootVolume() {
        return this.bootVolume != null;
    }

    @Override
    public A withNewBootVolume(String encryptionKey) {
        return this.withBootVolume(new BootVolume(encryptionKey));
    }

    @Override
    public MachinePoolFluent.BootVolumeNested<A> withNewBootVolume() {
        return new BootVolumeNestedImpl();
    }

    @Override
    public MachinePoolFluent.BootVolumeNested<A> withNewBootVolumeLike(BootVolume item) {
        return new BootVolumeNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.BootVolumeNested<A> editBootVolume() {
        return this.withNewBootVolumeLike(this.getBootVolume());
    }

    @Override
    public MachinePoolFluent.BootVolumeNested<A> editOrNewBootVolume() {
        return this.withNewBootVolumeLike(this.getBootVolume() != null ? this.getBootVolume() : new BootVolumeBuilder().build());
    }

    @Override
    public MachinePoolFluent.BootVolumeNested<A> editOrNewBootVolumeLike(BootVolume item) {
        return this.withNewBootVolumeLike(this.getBootVolume() != null ? this.getBootVolume() : item);
    }

    @Override
    public A addToDedicatedHosts(Integer index, DedicatedHost item) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
        }
        DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
        this._visitables.get("dedicatedHosts").add(index >= 0 ? index.intValue() : this._visitables.get("dedicatedHosts").size(), builder);
        this.dedicatedHosts.add(index >= 0 ? index.intValue() : this.dedicatedHosts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDedicatedHosts(Integer index, DedicatedHost item) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
        }
        DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
        if (index < 0 || index >= this._visitables.get("dedicatedHosts").size()) {
            this._visitables.get("dedicatedHosts").add(builder);
        } else {
            this._visitables.get("dedicatedHosts").set(index, builder);
        }
        if (index < 0 || index >= this.dedicatedHosts.size()) {
            this.dedicatedHosts.add(builder);
        } else {
            this.dedicatedHosts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDedicatedHosts(DedicatedHost ... items) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDedicatedHosts(Collection<DedicatedHost> items) {
        if (this.dedicatedHosts == null) {
            this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
        }
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").add(builder);
            this.dedicatedHosts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDedicatedHosts(DedicatedHost ... items) {
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").remove(builder);
            if (this.dedicatedHosts == null) continue;
            this.dedicatedHosts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDedicatedHosts(Collection<DedicatedHost> items) {
        for (DedicatedHost item : items) {
            DedicatedHostBuilder builder = new DedicatedHostBuilder(item);
            this._visitables.get("dedicatedHosts").remove(builder);
            if (this.dedicatedHosts == null) continue;
            this.dedicatedHosts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDedicatedHosts(Predicate<DedicatedHostBuilder> predicate) {
        if (this.dedicatedHosts == null) {
            return (A)this;
        }
        Iterator<DedicatedHostBuilder> each = this.dedicatedHosts.iterator();
        Object visitables = this._visitables.get("dedicatedHosts");
        while (each.hasNext()) {
            DedicatedHostBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DedicatedHost> getDedicatedHosts() {
        return MachinePoolFluentImpl.build(this.dedicatedHosts);
    }

    @Override
    public List<DedicatedHost> buildDedicatedHosts() {
        return MachinePoolFluentImpl.build(this.dedicatedHosts);
    }

    @Override
    public DedicatedHost buildDedicatedHost(Integer index) {
        return this.dedicatedHosts.get(index).build();
    }

    @Override
    public DedicatedHost buildFirstDedicatedHost() {
        return this.dedicatedHosts.get(0).build();
    }

    @Override
    public DedicatedHost buildLastDedicatedHost() {
        return this.dedicatedHosts.get(this.dedicatedHosts.size() - 1).build();
    }

    @Override
    public DedicatedHost buildMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        for (DedicatedHostBuilder item : this.dedicatedHosts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        for (DedicatedHostBuilder item : this.dedicatedHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDedicatedHosts(List<DedicatedHost> dedicatedHosts) {
        if (this.dedicatedHosts != null) {
            this._visitables.get("dedicatedHosts").removeAll(this.dedicatedHosts);
        }
        if (dedicatedHosts != null) {
            this.dedicatedHosts = new ArrayList<DedicatedHostBuilder>();
            for (DedicatedHost item : dedicatedHosts) {
                this.addToDedicatedHosts(item);
            }
        } else {
            this.dedicatedHosts = null;
        }
        return (A)this;
    }

    @Override
    public A withDedicatedHosts(DedicatedHost ... dedicatedHosts) {
        if (this.dedicatedHosts != null) {
            this.dedicatedHosts.clear();
        }
        if (dedicatedHosts != null) {
            for (DedicatedHost item : dedicatedHosts) {
                this.addToDedicatedHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDedicatedHosts() {
        return this.dedicatedHosts != null && !this.dedicatedHosts.isEmpty();
    }

    @Override
    public A addNewDedicatedHost(String name, String profile) {
        return this.addToDedicatedHosts(new DedicatedHost(name, profile));
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> addNewDedicatedHost() {
        return new DedicatedHostsNestedImpl();
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> addNewDedicatedHostLike(DedicatedHost item) {
        return new DedicatedHostsNestedImpl(-1, item);
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> setNewDedicatedHostLike(Integer index, DedicatedHost item) {
        return new DedicatedHostsNestedImpl(index, item);
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> editDedicatedHost(Integer index) {
        if (this.dedicatedHosts.size() <= index) {
            throw new RuntimeException("Can't edit dedicatedHosts. Index exceeds size.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> editFirstDedicatedHost() {
        if (this.dedicatedHosts.size() == 0) {
            throw new RuntimeException("Can't edit first dedicatedHosts. The list is empty.");
        }
        return this.setNewDedicatedHostLike(0, this.buildDedicatedHost(0));
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> editLastDedicatedHost() {
        int index = this.dedicatedHosts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dedicatedHosts. The list is empty.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    @Override
    public MachinePoolFluent.DedicatedHostsNested<A> editMatchingDedicatedHost(Predicate<DedicatedHostBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dedicatedHosts.size(); ++i) {
            if (!predicate.test(this.dedicatedHosts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dedicatedHosts. No match found.");
        }
        return this.setNewDedicatedHostLike(index, this.buildDedicatedHost(index));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addNewZone(String arg0) {
        return this.addToZones(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.bootVolume != null ? !this.bootVolume.equals(that.bootVolume) : that.bootVolume != null) {
            return false;
        }
        if (this.dedicatedHosts != null ? !this.dedicatedHosts.equals(that.dedicatedHosts) : that.dedicatedHosts != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.zones != null ? !this.zones.equals(that.zones) : that.zones != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.bootVolume, this.dedicatedHosts, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public class DedicatedHostsNestedImpl<N>
    extends DedicatedHostFluentImpl<MachinePoolFluent.DedicatedHostsNested<N>>
    implements MachinePoolFluent.DedicatedHostsNested<N>,
    Nested<N> {
        DedicatedHostBuilder builder;
        Integer index;

        DedicatedHostsNestedImpl(Integer index, DedicatedHost item) {
            this.index = index;
            this.builder = new DedicatedHostBuilder(this, item);
        }

        DedicatedHostsNestedImpl() {
            this.index = -1;
            this.builder = new DedicatedHostBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.setToDedicatedHosts(this.index, this.builder.build());
        }

        @Override
        public N endDedicatedHost() {
            return this.and();
        }
    }

    public class BootVolumeNestedImpl<N>
    extends BootVolumeFluentImpl<MachinePoolFluent.BootVolumeNested<N>>
    implements MachinePoolFluent.BootVolumeNested<N>,
    Nested<N> {
        BootVolumeBuilder builder;

        BootVolumeNestedImpl(BootVolume item) {
            this.builder = new BootVolumeBuilder(this, item);
        }

        BootVolumeNestedImpl() {
            this.builder = new BootVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withBootVolume(this.builder.build());
        }

        @Override
        public N endBootVolume() {
            return this.and();
        }
    }
}

