/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DNS;
import io.fabric8.openshift.api.model.DNSFluent;
import io.fabric8.openshift.api.model.DNSFluentImpl;
import java.util.Objects;

public class DNSBuilder
extends DNSFluentImpl<DNSBuilder>
implements VisitableBuilder<DNS, DNSBuilder> {
    DNSFluent<?> fluent;
    Boolean validationEnabled;

    public DNSBuilder() {
        this(false);
    }

    public DNSBuilder(Boolean validationEnabled) {
        this(new DNS(), validationEnabled);
    }

    public DNSBuilder(DNSFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DNSBuilder(DNSFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DNS(), validationEnabled);
    }

    public DNSBuilder(DNSFluent<?> fluent, DNS instance) {
        this(fluent, instance, false);
    }

    public DNSBuilder(DNSFluent<?> fluent, DNS instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public DNSBuilder(DNS instance) {
        this(instance, (Boolean)false);
    }

    public DNSBuilder(DNS instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DNS build() {
        DNS buildable = new DNS(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSBuilder that = (DNSBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

