/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.ComponentRouteStatus;
import io.fabric8.openshift.api.model.ComponentRouteStatusFluent;
import io.fabric8.openshift.api.model.ObjectReference;
import io.fabric8.openshift.api.model.ObjectReferenceBuilder;
import io.fabric8.openshift.api.model.ObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ComponentRouteStatusFluentImpl<A extends ComponentRouteStatusFluent<A>>
extends BaseFluent<A>
implements ComponentRouteStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private List<String> consumingUsers = new ArrayList<String>();
    private List<String> currentHostnames = new ArrayList<String>();
    private String defaultHostname;
    private String name;
    private String namespace;
    private List<ObjectReferenceBuilder> relatedObjects = new ArrayList<ObjectReferenceBuilder>();
    private Map<String, Object> additionalProperties;

    public ComponentRouteStatusFluentImpl() {
    }

    public ComponentRouteStatusFluentImpl(ComponentRouteStatus instance) {
        this.withConditions(instance.getConditions());
        this.withConsumingUsers(instance.getConsumingUsers());
        this.withCurrentHostnames(instance.getCurrentHostnames());
        this.withDefaultHostname(instance.getDefaultHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withRelatedObjects(instance.getRelatedObjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addToConsumingUsers(Integer index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConsumingUsers(Integer index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConsumingUsers(String ... items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConsumingUsers(Collection<String> items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConsumingUsers(String ... items) {
        for (String item : items) {
            if (this.consumingUsers == null) continue;
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConsumingUsers(Collection<String> items) {
        for (String item : items) {
            if (this.consumingUsers == null) continue;
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConsumingUsers() {
        return this.consumingUsers;
    }

    @Override
    public String getConsumingUser(Integer index) {
        return this.consumingUsers.get(index);
    }

    @Override
    public String getFirstConsumingUser() {
        return this.consumingUsers.get(0);
    }

    @Override
    public String getLastConsumingUser() {
        return this.consumingUsers.get(this.consumingUsers.size() - 1);
    }

    @Override
    public String getMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConsumingUsers(List<String> consumingUsers) {
        if (consumingUsers != null) {
            this.consumingUsers = new ArrayList<String>();
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        } else {
            this.consumingUsers = null;
        }
        return (A)this;
    }

    @Override
    public A withConsumingUsers(String ... consumingUsers) {
        if (this.consumingUsers != null) {
            this.consumingUsers.clear();
        }
        if (consumingUsers != null) {
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConsumingUsers() {
        return this.consumingUsers != null && !this.consumingUsers.isEmpty();
    }

    @Override
    public A addNewConsumingUser(String arg0) {
        return this.addToConsumingUsers(new String(arg0));
    }

    @Override
    public A addToCurrentHostnames(Integer index, String item) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        this.currentHostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCurrentHostnames(Integer index, String item) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        this.currentHostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCurrentHostnames(String ... items) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.currentHostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCurrentHostnames(Collection<String> items) {
        if (this.currentHostnames == null) {
            this.currentHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.currentHostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCurrentHostnames(String ... items) {
        for (String item : items) {
            if (this.currentHostnames == null) continue;
            this.currentHostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCurrentHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.currentHostnames == null) continue;
            this.currentHostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCurrentHostnames() {
        return this.currentHostnames;
    }

    @Override
    public String getCurrentHostname(Integer index) {
        return this.currentHostnames.get(index);
    }

    @Override
    public String getFirstCurrentHostname() {
        return this.currentHostnames.get(0);
    }

    @Override
    public String getLastCurrentHostname() {
        return this.currentHostnames.get(this.currentHostnames.size() - 1);
    }

    @Override
    public String getMatchingCurrentHostname(Predicate<String> predicate) {
        for (String item : this.currentHostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCurrentHostname(Predicate<String> predicate) {
        for (String item : this.currentHostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCurrentHostnames(List<String> currentHostnames) {
        if (currentHostnames != null) {
            this.currentHostnames = new ArrayList<String>();
            for (String item : currentHostnames) {
                this.addToCurrentHostnames(item);
            }
        } else {
            this.currentHostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withCurrentHostnames(String ... currentHostnames) {
        if (this.currentHostnames != null) {
            this.currentHostnames.clear();
        }
        if (currentHostnames != null) {
            for (String item : currentHostnames) {
                this.addToCurrentHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHostnames() {
        return this.currentHostnames != null && !this.currentHostnames.isEmpty();
    }

    @Override
    public A addNewCurrentHostname(String arg0) {
        return this.addToCurrentHostnames(new String(arg0));
    }

    @Override
    public String getDefaultHostname() {
        return this.defaultHostname;
    }

    @Override
    public A withDefaultHostname(String defaultHostname) {
        this.defaultHostname = defaultHostname;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultHostname() {
        return this.defaultHostname != null;
    }

    @Override
    @Deprecated
    public A withNewDefaultHostname(String arg0) {
        return this.withDefaultHostname(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public A withNewNamespace(String arg0) {
        return this.withNamespace(new String(arg0));
    }

    @Override
    public A addToRelatedObjects(Integer index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.get("relatedObjects").add(index >= 0 ? index.intValue() : this._visitables.get("relatedObjects").size(), builder);
        this.relatedObjects.add(index >= 0 ? index.intValue() : this.relatedObjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRelatedObjects(Integer index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("relatedObjects").size()) {
            this._visitables.get("relatedObjects").add(builder);
        } else {
            this._visitables.get("relatedObjects").set(index, builder);
        }
        if (index < 0 || index >= this.relatedObjects.size()) {
            this.relatedObjects.add(builder);
        } else {
            this.relatedObjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRelatedObjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            if (this.relatedObjects == null) continue;
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            if (this.relatedObjects == null) continue;
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.relatedObjects.iterator();
        Object visitables = this._visitables.get("relatedObjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getRelatedObjects() {
        return ComponentRouteStatusFluentImpl.build(this.relatedObjects);
    }

    @Override
    public List<ObjectReference> buildRelatedObjects() {
        return ComponentRouteStatusFluentImpl.build(this.relatedObjects);
    }

    @Override
    public ObjectReference buildRelatedObject(Integer index) {
        return this.relatedObjects.get(index).build();
    }

    @Override
    public ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    @Override
    public ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(this.relatedObjects.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRelatedObjects(List<ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) {
            this._visitables.get("relatedObjects").removeAll(this.relatedObjects);
        }
        if (relatedObjects != null) {
            this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        } else {
            this.relatedObjects = null;
        }
        return (A)this;
    }

    @Override
    public A withRelatedObjects(ObjectReference ... relatedObjects) {
        if (this.relatedObjects != null) {
            this.relatedObjects.clear();
        }
        if (relatedObjects != null) {
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelatedObjects() {
        return this.relatedObjects != null && !this.relatedObjects.isEmpty();
    }

    @Override
    public A addNewRelatedObject(String group, String name, String namespace, String resource) {
        return this.addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNestedImpl();
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
        return new RelatedObjectsNestedImpl(-1, item);
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> setNewRelatedObjectLike(Integer index, ObjectReference item) {
        return new RelatedObjectsNestedImpl(index, item);
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> editRelatedObject(Integer index) {
        if (this.relatedObjects.size() <= index) {
            throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> editFirstRelatedObject() {
        if (this.relatedObjects.size() == 0) {
            throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(0, this.buildRelatedObject(0));
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> editLastRelatedObject() {
        int index = this.relatedObjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    @Override
    public ComponentRouteStatusFluent.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedObjects.size(); ++i) {
            if (!predicate.test(this.relatedObjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentRouteStatusFluentImpl that = (ComponentRouteStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.consumingUsers != null ? !this.consumingUsers.equals(that.consumingUsers) : that.consumingUsers != null) {
            return false;
        }
        if (this.currentHostnames != null ? !this.currentHostnames.equals(that.currentHostnames) : that.currentHostnames != null) {
            return false;
        }
        if (this.defaultHostname != null ? !this.defaultHostname.equals(that.defaultHostname) : that.defaultHostname != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.relatedObjects != null ? !this.relatedObjects.equals(that.relatedObjects) : that.relatedObjects != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.consumingUsers, this.currentHostnames, this.defaultHostname, this.name, this.namespace, this.relatedObjects, this.additionalProperties, super.hashCode());
    }

    public class RelatedObjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ComponentRouteStatusFluent.RelatedObjectsNested<N>>
    implements ComponentRouteStatusFluent.RelatedObjectsNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;
        Integer index;

        RelatedObjectsNestedImpl(Integer index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RelatedObjectsNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentRouteStatusFluentImpl.this.setToRelatedObjects(this.index, this.builder.build());
        }

        @Override
        public N endRelatedObject() {
            return this.and();
        }
    }
}

