/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.rbac.RoleRefFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleRefFluentImpl;
import java.util.Objects;

public class RoleRefBuilder
extends RoleRefFluentImpl<RoleRefBuilder>
implements VisitableBuilder<RoleRef, RoleRefBuilder> {
    RoleRefFluent<?> fluent;
    Boolean validationEnabled;

    public RoleRefBuilder() {
        this(false);
    }

    public RoleRefBuilder(Boolean validationEnabled) {
        this(new RoleRef(), validationEnabled);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RoleRef(), validationEnabled);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, RoleRef instance) {
        this(fluent, instance, false);
    }

    public RoleRefBuilder(RoleRefFluent<?> fluent, RoleRef instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RoleRefBuilder(RoleRef instance) {
        this(instance, (Boolean)false);
    }

    public RoleRefBuilder(RoleRef instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RoleRef build() {
        RoleRef buildable = new RoleRef(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleRefBuilder that = (RoleRefBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

