/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TemplateInstanceSpec;
import io.fabric8.openshift.api.model.TemplateInstanceSpecFluent;
import io.fabric8.openshift.api.model.TemplateInstanceSpecFluentImpl;
import java.util.Objects;

public class TemplateInstanceSpecBuilder
extends TemplateInstanceSpecFluentImpl<TemplateInstanceSpecBuilder>
implements VisitableBuilder<TemplateInstanceSpec, TemplateInstanceSpecBuilder> {
    TemplateInstanceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TemplateInstanceSpecBuilder() {
        this(false);
    }

    public TemplateInstanceSpecBuilder(Boolean validationEnabled) {
        this(new TemplateInstanceSpec(), validationEnabled);
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TemplateInstanceSpec(), validationEnabled);
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent, TemplateInstanceSpec instance) {
        this(fluent, instance, false);
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent, TemplateInstanceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRequester(instance.getRequester());
        fluent.withSecret(instance.getSecret());
        fluent.withTemplate(instance.getTemplate());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpec instance) {
        this(instance, (Boolean)false);
    }

    public TemplateInstanceSpecBuilder(TemplateInstanceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRequester(instance.getRequester());
        this.withSecret(instance.getSecret());
        this.withTemplate(instance.getTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TemplateInstanceSpec build() {
        TemplateInstanceSpec buildable = new TemplateInstanceSpec(this.fluent.getRequester(), this.fluent.getSecret(), this.fluent.getTemplate());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateInstanceSpecBuilder that = (TemplateInstanceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

