/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private static final Set<String> RETRIABLE_RESOURCES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(HasMetadata.getPlural(LocalSubjectAccessReview.class), HasMetadata.getPlural(LocalResourceAccessReview.class), HasMetadata.getPlural(ResourceAccessReview.class), HasMetadata.getPlural(SelfSubjectRulesReview.class), HasMetadata.getPlural(SubjectRulesReview.class), HasMetadata.getPlural(SubjectAccessReview.class), HasMetadata.getPlural(SelfSubjectAccessReview.class))));
    private final HttpClient client;
    private final OpenShiftConfig config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(HttpClient client, OpenShiftConfig config) {
        this.client = client;
        this.config = config;
    }

    @Override
    public void before(BasicBuilder builder, HttpHeaders headers) {
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty(token) && (headers.headers(AUTHORIZATION).isEmpty() || Utils.isNullOrEmpty(headers.headers(AUTHORIZATION).get(0)))) {
            this.setAuthHeader(builder, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterFailure(BasicBuilder builder, HttpResponse<?> response) {
        if (this.shouldProceed(response.request(), response)) {
            return false;
        }
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty(this.config.getUsername()) && Utils.isNotNullOrEmpty(this.config.getPassword())) {
            HttpClient httpClient = this.client;
            synchronized (httpClient) {
                this.oauthToken.set(null);
                token = this.authorize();
                if (token != null) {
                    this.oauthToken.set(token);
                }
            }
        } else if (Utils.isNotNullOrEmpty(this.config.getOauthToken())) {
            token = this.config.getOauthToken();
            this.oauthToken.set(token);
        }
        if (Utils.isNotNullOrEmpty(token)) {
            this.setAuthHeader(builder, token);
            return true;
        }
        return false;
    }

    private void setAuthHeader(BasicBuilder builder, String token) {
        if (token != null) {
            builder.setHeader(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    private String authorize() {
        try {
            String token;
            HttpClient.Builder builder = this.client.newBuilder();
            builder.addOrReplaceInterceptor("TOKEN", null);
            HttpClient clone = builder.build();
            URL url = new URL(URLUtils.join(this.config.getMasterUrl(), AUTHORIZATION_SERVER_PATH));
            HttpResponse<String> response = clone.send(clone.newHttpRequestBuilder().url(url).build(), String.class);
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = response.body();
            JsonNode jsonResponse = Serialization.jsonMapper().readTree(body);
            String authorizationServer = jsonResponse.get("authorization_endpoint").asText();
            url = new URL(authorizationServer + AUTHORIZE_QUERY);
            String credential = HttpClientUtils.basicCredentials(this.config.getUsername(), this.config.getPassword());
            response = clone.send(this.client.newHttpRequestBuilder().url(url).setHeader(AUTHORIZATION, credential).build(), String.class);
            response = response.previousResponse().isPresent() ? response.previousResponse().get() : response;
            List<String> location = response.headers(LOCATION);
            String string = token = !location.isEmpty() ? location.get(0) : null;
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + "), to the authorization request. Missing header:[" + LOCATION + "]!");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private boolean shouldProceed(HttpRequest request, HttpResponse<?> response) {
        String url = request.uri().toString();
        String method = request.method();
        if (method.equals("POST")) {
            if (RETRIABLE_RESOURCES.stream().anyMatch(url::endsWith)) {
                return false;
            }
        }
        return response.code() != 401 && response.code() != 403;
    }
}

