/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.uploadable;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class PodUploadWebSocketListener
implements WebSocket.Listener {
    private static final byte FLAG_STDIN = 0;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final AtomicReference<String> error = new AtomicReference();
    private final CountDownLatch readyLatch = new CountDownLatch(1);
    private final CountDownLatch completeLatch = new CountDownLatch(1);

    PodUploadWebSocketListener() {
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.webSocketRef.set(webSocket);
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        if (this.readyLatch.getCount() > 0L && bytes.remaining() == 1) {
            this.readyLatch.countDown();
        } else if (bytes.remaining() > 1) {
            bytes.position(1);
            this.error.set(StandardCharsets.UTF_8.decode(bytes).toString());
        }
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason) {
        this.completeLatch.countDown();
    }

    @Override
    public void onError(WebSocket webSocket, Throwable t) {
        this.error.set(String.format("PodUploadWebSocketListener failed with - %s", t.getMessage()));
        while (this.readyLatch.getCount() > 0L) {
            this.readyLatch.countDown();
        }
        while (this.completeLatch.getCount() > 0L) {
            this.completeLatch.countDown();
        }
    }

    final void checkError() {
        if (this.error.get() != null && !this.error.get().trim().isEmpty()) {
            throw new KubernetesClientException(this.error.get());
        }
    }

    final void waitUntilReady(int timeoutMilliseconds) throws IOException, InterruptedException {
        if (!this.readyLatch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
            this.checkError();
            throw new IOException("Connection to server timed out");
        }
    }

    final void waitUntilComplete(int timeoutMilliseconds) throws IOException, InterruptedException {
        while (this.webSocketRef.get().queueSize() > 0L && this.completeLatch.getCount() > 0L) {
            this.checkError();
            Thread.sleep(50L);
        }
        this.webSocketRef.get().sendClose(1000, "Operation completed");
        if (!this.completeLatch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
            throw new IOException("Upload operation timed out before completing");
        }
        this.checkError();
    }

    final void send(byte[] data, int length) {
        this.checkError();
        this.waitForQueue(length);
        byte[] toSend = new byte[length + 1];
        toSend[0] = 0;
        System.arraycopy(data, 0, toSend, 1, length);
        this.webSocketRef.get().send(ByteBuffer.wrap(toSend));
    }

    final void waitForQueue(int length) {
        try {
            while (this.webSocketRef.get().queueSize() + (long)length > 0x1000000L && !Thread.interrupted()) {
                this.checkError();
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

