/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfig;
import io.fabric8.openshift.api.model.operator.v1.HybridOverlayConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HybridOverlayConfigFluentImpl<A extends HybridOverlayConfigFluent<A>>
extends BaseFluent<A>
implements HybridOverlayConfigFluent<A> {
    private List<ClusterNetworkEntryBuilder> hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
    private Integer hybridOverlayVXLANPort;
    private Map<String, Object> additionalProperties;

    public HybridOverlayConfigFluentImpl() {
    }

    public HybridOverlayConfigFluentImpl(HybridOverlayConfig instance) {
        this.withHybridClusterNetwork(instance.getHybridClusterNetwork());
        this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToHybridClusterNetwork(Integer index, ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get("hybridClusterNetwork").add(index >= 0 ? index.intValue() : this._visitables.get("hybridClusterNetwork").size(), builder);
        this.hybridClusterNetwork.add(index >= 0 ? index.intValue() : this.hybridClusterNetwork.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHybridClusterNetwork(Integer index, ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get("hybridClusterNetwork").size()) {
            this._visitables.get("hybridClusterNetwork").add(builder);
        } else {
            this._visitables.get("hybridClusterNetwork").set(index, builder);
        }
        if (index < 0 || index >= this.hybridClusterNetwork.size()) {
            this.hybridClusterNetwork.add(builder);
        } else {
            this.hybridClusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHybridClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.hybridClusterNetwork == null) {
            this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("hybridClusterNetwork").add(builder);
            this.hybridClusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHybridClusterNetwork(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("hybridClusterNetwork").remove(builder);
            if (this.hybridClusterNetwork == null) continue;
            this.hybridClusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("hybridClusterNetwork").remove(builder);
            if (this.hybridClusterNetwork == null) continue;
            this.hybridClusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.hybridClusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.hybridClusterNetwork.iterator();
        Object visitables = this._visitables.get("hybridClusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getHybridClusterNetwork() {
        return HybridOverlayConfigFluentImpl.build(this.hybridClusterNetwork);
    }

    @Override
    public List<ClusterNetworkEntry> buildHybridClusterNetwork() {
        return HybridOverlayConfigFluentImpl.build(this.hybridClusterNetwork);
    }

    @Override
    public ClusterNetworkEntry buildHybridClusterNetwork(Integer index) {
        return this.hybridClusterNetwork.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(this.hybridClusterNetwork.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.hybridClusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.hybridClusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHybridClusterNetwork(List<ClusterNetworkEntry> hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {
            this._visitables.get("hybridClusterNetwork").removeAll(this.hybridClusterNetwork);
        }
        if (hybridClusterNetwork != null) {
            this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : hybridClusterNetwork) {
                this.addToHybridClusterNetwork(item);
            }
        } else {
            this.hybridClusterNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withHybridClusterNetwork(ClusterNetworkEntry ... hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {
            this.hybridClusterNetwork.clear();
        }
        if (hybridClusterNetwork != null) {
            for (ClusterNetworkEntry item : hybridClusterNetwork) {
                this.addToHybridClusterNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHybridClusterNetwork() {
        return this.hybridClusterNetwork != null && !this.hybridClusterNetwork.isEmpty();
    }

    @Override
    public A addNewHybridClusterNetwork(String cidr, Integer hostPrefix) {
        return this.addToHybridClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetwork() {
        return new HybridClusterNetworkNestedImpl();
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(ClusterNetworkEntry item) {
        return new HybridClusterNetworkNestedImpl(-1, item);
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(Integer index, ClusterNetworkEntry item) {
        return new HybridClusterNetworkNestedImpl(index, item);
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editHybridClusterNetwork(Integer index) {
        if (this.hybridClusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit hybridClusterNetwork. Index exceeds size.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editFirstHybridClusterNetwork() {
        if (this.hybridClusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first hybridClusterNetwork. The list is empty.");
        }
        return this.setNewHybridClusterNetworkLike(0, this.buildHybridClusterNetwork(0));
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editLastHybridClusterNetwork() {
        int index = this.hybridClusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hybridClusterNetwork. The list is empty.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    @Override
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hybridClusterNetwork.size(); ++i) {
            if (!predicate.test(this.hybridClusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hybridClusterNetwork. No match found.");
        }
        return this.setNewHybridClusterNetworkLike(index, this.buildHybridClusterNetwork(index));
    }

    @Override
    public Integer getHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort;
    }

    @Override
    public A withHybridOverlayVXLANPort(Integer hybridOverlayVXLANPort) {
        this.hybridOverlayVXLANPort = hybridOverlayVXLANPort;
        return (A)this;
    }

    @Override
    public Boolean hasHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HybridOverlayConfigFluentImpl that = (HybridOverlayConfigFluentImpl)o;
        if (this.hybridClusterNetwork != null ? !this.hybridClusterNetwork.equals(that.hybridClusterNetwork) : that.hybridClusterNetwork != null) {
            return false;
        }
        if (this.hybridOverlayVXLANPort != null ? !this.hybridOverlayVXLANPort.equals(that.hybridOverlayVXLANPort) : that.hybridOverlayVXLANPort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.hybridClusterNetwork, this.hybridOverlayVXLANPort, this.additionalProperties, super.hashCode());
    }

    public class HybridClusterNetworkNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<HybridOverlayConfigFluent.HybridClusterNetworkNested<N>>
    implements HybridOverlayConfigFluent.HybridClusterNetworkNested<N>,
    Nested<N> {
        ClusterNetworkEntryBuilder builder;
        Integer index;

        HybridClusterNetworkNestedImpl(Integer index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        HybridClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)HybridOverlayConfigFluentImpl.this.setToHybridClusterNetwork(this.index, this.builder.build());
        }

        @Override
        public N endHybridClusterNetwork() {
            return this.and();
        }
    }
}

