/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArrayFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JSONSchemaPropsOrStringArrayFluentImpl<A extends JSONSchemaPropsOrStringArrayFluent<A>>
extends BaseFluent<A>
implements JSONSchemaPropsOrStringArrayFluent<A> {
    private List<String> property = new ArrayList<String>();
    private JSONSchemaPropsBuilder schema;
    private Map<String, Object> additionalProperties;

    public JSONSchemaPropsOrStringArrayFluentImpl() {
    }

    public JSONSchemaPropsOrStringArrayFluentImpl(JSONSchemaPropsOrStringArray instance) {
        this.withProperty(instance.getProperty());
        this.withSchema(instance.getSchema());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToProperty(Integer index, String item) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        this.property.add(index, item);
        return (A)this;
    }

    @Override
    public A setToProperty(Integer index, String item) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        this.property.set(index, item);
        return (A)this;
    }

    @Override
    public A addToProperty(String ... items) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        for (String item : items) {
            this.property.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToProperty(Collection<String> items) {
        if (this.property == null) {
            this.property = new ArrayList<String>();
        }
        for (String item : items) {
            this.property.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperty(String ... items) {
        for (String item : items) {
            if (this.property == null) continue;
            this.property.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromProperty(Collection<String> items) {
        for (String item : items) {
            if (this.property == null) continue;
            this.property.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getProperty() {
        return this.property;
    }

    @Override
    public String getProperty(Integer index) {
        return this.property.get(index);
    }

    @Override
    public String getFirstProperty() {
        return this.property.get(0);
    }

    @Override
    public String getLastProperty() {
        return this.property.get(this.property.size() - 1);
    }

    @Override
    public String getMatchingProperty(Predicate<String> predicate) {
        for (String item : this.property) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingProperty(Predicate<String> predicate) {
        for (String item : this.property) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withProperty(List<String> property) {
        if (property != null) {
            this.property = new ArrayList<String>();
            for (String item : property) {
                this.addToProperty(item);
            }
        } else {
            this.property = null;
        }
        return (A)this;
    }

    @Override
    public A withProperty(String ... property) {
        if (this.property != null) {
            this.property.clear();
        }
        if (property != null) {
            for (String item : property) {
                this.addToProperty(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasProperty() {
        return this.property != null && !this.property.isEmpty();
    }

    @Override
    public A addNewProperty(String arg0) {
        return this.addToProperty(new String(arg0));
    }

    @Override
    @Deprecated
    public JSONSchemaProps getSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    @Override
    public JSONSchemaProps buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    @Override
    public A withSchema(JSONSchemaProps schema) {
        this._visitables.get("schema").remove(this.schema);
        if (schema != null) {
            this.schema = new JSONSchemaPropsBuilder(schema);
            this._visitables.get("schema").add(this.schema);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSchema() {
        return this.schema != null;
    }

    @Override
    public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> withNewSchema() {
        return new SchemaNestedImpl();
    }

    @Override
    public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
        return new SchemaNestedImpl(item);
    }

    @Override
    public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(this.getSchema());
    }

    @Override
    public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(this.getSchema() != null ? this.getSchema() : new JSONSchemaPropsBuilder().build());
    }

    @Override
    public JSONSchemaPropsOrStringArrayFluent.SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
        return this.withNewSchemaLike(this.getSchema() != null ? this.getSchema() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONSchemaPropsOrStringArrayFluentImpl that = (JSONSchemaPropsOrStringArrayFluentImpl)o;
        if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.schema, this.additionalProperties, super.hashCode());
    }

    public class SchemaNestedImpl<N>
    extends JSONSchemaPropsFluentImpl<JSONSchemaPropsOrStringArrayFluent.SchemaNested<N>>
    implements JSONSchemaPropsOrStringArrayFluent.SchemaNested<N>,
    Nested<N> {
        JSONSchemaPropsBuilder builder;

        SchemaNestedImpl(JSONSchemaProps item) {
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        SchemaNestedImpl() {
            this.builder = new JSONSchemaPropsBuilder(this);
        }

        @Override
        public N and() {
            return (N)JSONSchemaPropsOrStringArrayFluentImpl.this.withSchema(this.builder.build());
        }

        @Override
        public N endSchema() {
            return this.and();
        }
    }
}

