/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;

public class OpenShiftReadiness
extends Readiness {
    private static final String OPENSHIFT_READINESS_APPLICABLE_RESOURCES = "Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController, DeploymentConfig";
    private static OpenShiftReadiness instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenShiftReadiness getInstance() {
        if (instance != null) return instance;
        Class<OpenShiftReadiness> clazz = OpenShiftReadiness.class;
        synchronized (OpenShiftReadiness.class) {
            instance = new OpenShiftReadiness();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected boolean isReadinessApplicable(HasMetadata item) {
        return super.isReadinessApplicable(item) || item instanceof DeploymentConfig;
    }

    @Override
    protected boolean isResourceReady(HasMetadata item) {
        if (item instanceof DeploymentConfig) {
            return OpenShiftReadiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        return super.isResourceReady(item);
    }

    @Override
    protected String getReadinessResourcesList() {
        return OPENSHIFT_READINESS_APPLICABLE_RESOURCES;
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }
}

