/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaFIFO<T>
implements Store<Object> {
    private static final Logger log = LoggerFactory.getLogger(DeltaFIFO.class);
    private Function<T, String> keyFunc;
    private Map<String, Deque<AbstractMap.SimpleEntry<DeltaType, Object>>> items;
    private Deque<String> queue;
    private Store<T> knownObjects;
    private boolean populated = false;
    private int initialPopulationCount;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Condition notEmpty;

    public DeltaFIFO(Function<T, String> keyFunc, Store knownObjects) {
        this.keyFunc = keyFunc;
        this.knownObjects = knownObjects;
        this.items = new HashMap<String, Deque<AbstractMap.SimpleEntry<DeltaType, Object>>>();
        this.queue = new LinkedList<String>();
        this.notEmpty = this.lock.writeLock().newCondition();
    }

    @Override
    public void add(Object obj) {
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            this.queueActionLocked(DeltaType.ADDITION, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void update(Object obj) {
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            this.queueActionLocked(DeltaType.UPDATION, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void delete(Object obj) {
        String id = this.keyOf(obj);
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            if (this.knownObjects == null ? !this.items.containsKey(id) : this.knownObjects.getByKey(id) == null && !this.items.containsKey(id)) {
                return;
            }
            this.queueActionLocked(DeltaType.DELETION, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void replace(List list, String resourceVersion) {
        this.lock.writeLock().lock();
        try {
            void var5_9;
            HashSet<String> keys = new HashSet<String>();
            for (Object e : list) {
                String key = this.keyOf(e);
                keys.add(key);
                this.queueActionLocked(DeltaType.SYNCHRONIZATION, e);
            }
            if (this.knownObjects == null) {
                for (Map.Entry entry : this.items.entrySet()) {
                    if (keys.contains(entry.getKey())) continue;
                    Object deletedObj = null;
                    AbstractMap.SimpleEntry delta = (AbstractMap.SimpleEntry)((Deque)entry.getValue()).peekLast();
                    if (delta != null) {
                        deletedObj = delta.getValue();
                    }
                    this.queueActionLocked(DeltaType.DELETION, new DeletedFinalStateUnknown<Object>((String)entry.getKey(), deletedObj));
                }
                if (!this.populated) {
                    this.populated = true;
                    this.initialPopulationCount = list.size();
                }
                return;
            }
            List<String> knownKeys = this.knownObjects.listKeys();
            boolean bl = false;
            for (String knownKey : knownKeys) {
                if (keys.contains(knownKey)) continue;
                T deletedObj = this.knownObjects.getByKey(knownKey);
                if (deletedObj == null) {
                    log.warn("Key {} doesn't exist in the known object store, placing DeleteFinalStateUnknown marker without object", (Object)knownKey);
                }
                ++var5_9;
                this.queueActionLocked(DeltaType.DELETION, new DeletedFinalStateUnknown<T>(knownKey, deletedObj));
            }
            if (!this.populated) {
                this.populated = true;
                this.initialPopulationCount = list.size() + var5_9;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resync() {
        this.lock.writeLock().lock();
        try {
            if (this.knownObjects == null) {
                return;
            }
            List<String> keys = this.knownObjects.listKeys();
            for (String key : keys) {
                this.syncKeyLocked(key);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listKeys() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> keyList = new ArrayList<String>(this.items.size());
            for (Map.Entry<String, Deque<AbstractMap.SimpleEntry<DeltaType, Object>>> entry : this.items.entrySet()) {
                keyList.add(entry.getKey());
            }
            ArrayList<String> arrayList = keyList;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object get(Object obj) {
        String key = this.keyOf(obj);
        return this.getByKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deque<AbstractMap.SimpleEntry<DeltaType, Object>> getByKey(String key) {
        this.lock.readLock().lock();
        try {
            Deque<AbstractMap.SimpleEntry<DeltaType, Object>> deltas = this.items.get(key);
            if (deltas != null) {
                LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>> linkedList = new LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>>(deltas);
                return linkedList;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> list() {
        this.lock.readLock().lock();
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            for (Map.Entry<String, Deque<AbstractMap.SimpleEntry<DeltaType, Object>>> entry : this.items.entrySet()) {
                LinkedList copiedDeltas = new LinkedList(entry.getValue());
                objects.add(copiedDeltas);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deque<AbstractMap.SimpleEntry<DeltaType, Object>> pop(Consumer<Deque<AbstractMap.SimpleEntry<DeltaType, Object>>> func) throws InterruptedException {
        this.lock.writeLock().lock();
        try {
            String id;
            while (true) {
                if (this.queue.isEmpty()) {
                    this.notEmpty.await();
                    continue;
                }
                id = this.queue.removeFirst();
                if (this.initialPopulationCount > 0) {
                    --this.initialPopulationCount;
                }
                if (this.items.containsKey(id)) break;
            }
            Deque<AbstractMap.SimpleEntry<DeltaType, Object>> deltas = this.items.get(id);
            this.items.remove(id);
            func.accept(deltas);
            Deque<AbstractMap.SimpleEntry<DeltaType, Object>> deque = deltas;
            return deque;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean hasSynced() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.populated && this.initialPopulationCount == 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void isPopulated(boolean isPopulated) {
        this.lock.writeLock().lock();
        try {
            this.populated = isPopulated;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String keyOf(Object obj) {
        Object innerObj = obj;
        if (obj instanceof Deque) {
            Deque deltas = (Deque)obj;
            if (deltas.size() == 0) {
                throw new NoSuchElementException("0 length deltas object; can't get key");
            }
            innerObj = ((AbstractMap.SimpleEntry)deltas.peekLast()).getValue();
        }
        if (innerObj instanceof DeletedFinalStateUnknown) {
            return ((DeletedFinalStateUnknown)innerObj).key;
        }
        return this.keyFunc.apply(innerObj);
    }

    private void queueActionLocked(DeltaType actionType, Object obj) {
        String id = this.keyOf(obj);
        Deque<AbstractMap.SimpleEntry<DeltaType, Object>> deltas = this.items.get(id);
        if (deltas == null) {
            LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>> deltaList = new LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>>();
            deltaList.add(new AbstractMap.SimpleEntry<DeltaType, Object>(actionType, obj));
            deltas = new LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>>(deltaList);
        } else {
            deltas.add(new AbstractMap.SimpleEntry<DeltaType, Object>(actionType, obj));
        }
        Deque<AbstractMap.SimpleEntry<DeltaType, Object>> combinedDeltaList = this.combineDeltas((LinkedList)deltas);
        boolean exist = this.items.containsKey(id);
        if (combinedDeltaList != null && combinedDeltaList.size() > 0) {
            if (!exist) {
                this.queue.add(id);
            }
            this.items.put(id, new LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>>(combinedDeltaList));
            this.notEmpty.signalAll();
        } else {
            this.items.remove(id);
        }
    }

    private void syncKeyLocked(String key) {
        T obj = this.knownObjects.getByKey(key);
        if (obj == null) {
            return;
        }
        String id = this.keyOf(obj);
        Deque<AbstractMap.SimpleEntry<DeltaType, Object>> deltas = this.items.get(id);
        if (deltas != null && deltas != null && !deltas.isEmpty()) {
            return;
        }
        this.queueActionLocked(DeltaType.SYNCHRONIZATION, obj);
    }

    private Deque<AbstractMap.SimpleEntry<DeltaType, Object>> combineDeltas(LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>> deltas) {
        AbstractMap.SimpleEntry<DeltaType, Object> d2;
        if (deltas.size() < 2) {
            return deltas;
        }
        int size = deltas.size();
        AbstractMap.SimpleEntry<DeltaType, Object> d1 = deltas.peekLast();
        AbstractMap.SimpleEntry<DeltaType, Object> out = this.isDuplicate(d1, d2 = deltas.get(size - 2));
        if (out != null) {
            LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>> newDeltas = new LinkedList<AbstractMap.SimpleEntry<DeltaType, Object>>();
            newDeltas.addAll(deltas.subList(0, size - 2));
            newDeltas.add(out);
            return newDeltas;
        }
        return deltas;
    }

    private AbstractMap.SimpleEntry<DeltaType, Object> isDuplicate(AbstractMap.SimpleEntry<DeltaType, Object> d1, AbstractMap.SimpleEntry<DeltaType, Object> d2) {
        AbstractMap.SimpleEntry<DeltaType, Object> deletionDelta = this.isDeletionDup(d1, d2);
        if (deletionDelta != null) {
            return deletionDelta;
        }
        return null;
    }

    private AbstractMap.SimpleEntry<DeltaType, Object> isDeletionDup(AbstractMap.SimpleEntry<DeltaType, Object> d1, AbstractMap.SimpleEntry<DeltaType, Object> d2) {
        if (!d1.getKey().equals((Object)DeltaType.DELETION) || !d2.getKey().equals((Object)DeltaType.DELETION)) {
            return null;
        }
        Object obj = d2.getValue();
        return obj instanceof DeletedFinalStateUnknown ? d1 : d2;
    }

    Map<String, Deque<AbstractMap.SimpleEntry<DeltaType, Object>>> getItems() {
        return this.items;
    }

    public static enum DeltaType {
        ADDITION,
        UPDATION,
        DELETION,
        SYNCHRONIZATION;

    }

    public static final class DeletedFinalStateUnknown<T> {
        private String key;
        private T obj;

        DeletedFinalStateUnknown(String key, T obj) {
            this.key = key;
            this.obj = obj;
        }

        String getKey() {
            return this.key;
        }

        public T getObj() {
            return this.obj;
        }
    }
}

