/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.Pluralize;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
public abstract class CustomResource<S, T>
implements HasMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(CustomResource.class);
    public static final String NAMESPACE_SCOPE = "Namespaced";
    public static final String CLUSTER_SCOPE = "Cluster";
    private ObjectMeta metadata = new ObjectMeta();
    @JsonProperty(value="spec")
    private S spec;
    @JsonProperty(value="status")
    private T status;
    private final String singular;
    private final String crdName;
    private final String kind;
    private final String apiVersion;
    private final String scope;
    private final String plural;

    public CustomResource() {
        String version = HasMetadata.super.getApiVersion();
        Class<?> clazz = this.getClass();
        if (Utils.isNullOrEmpty(version)) {
            throw new IllegalArgumentException(clazz.getName() + " CustomResource must provide an API version using @" + Group.class.getName() + " and @" + Version.class.getName() + " annotations");
        }
        this.apiVersion = version;
        this.kind = HasMetadata.super.getKind();
        this.scope = this instanceof Namespaced ? NAMESPACE_SCOPE : CLUSTER_SCOPE;
        this.singular = CustomResource.getSingular(clazz);
        this.plural = CustomResource.getPlural(clazz);
        this.crdName = CustomResource.getCRDName(clazz);
    }

    public String toString() {
        return "CustomResource{kind='" + this.getKind() + '\'' + ", apiVersion='" + this.getApiVersion() + '\'' + ", metadata=" + this.metadata + ", spec=" + this.spec + ", status=" + this.status + '}';
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String version) {
        LOG.debug("Calling CustomResource#setApiVersion doesn't do anything because the API version is computed and shouldn't be changed");
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        LOG.debug("Calling CustomResource#setKind doesn't do anything because the Kind is computed and shouldn't be changed");
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public static String getPlural(Class<? extends CustomResource> clazz) {
        Plural fromAnnotation = clazz.getAnnotation(Plural.class);
        return fromAnnotation != null ? fromAnnotation.value().toLowerCase(Locale.ROOT) : Pluralize.toPlural(CustomResource.getSingular(clazz));
    }

    @JsonIgnore
    public String getPlural() {
        return this.plural;
    }

    public static String getSingular(Class<? extends CustomResource> clazz) {
        Singular fromAnnotation = clazz.getAnnotation(Singular.class);
        return (fromAnnotation != null ? fromAnnotation.value() : HasMetadata.getKind(clazz)).toLowerCase(Locale.ROOT);
    }

    @JsonIgnore
    public String getSingular() {
        return this.singular;
    }

    public static String getCRDName(Class<? extends CustomResource> clazz) {
        return CustomResource.getPlural(clazz) + "." + HasMetadata.getGroup(clazz);
    }

    @JsonIgnore
    public String getCRDName() {
        return this.crdName;
    }

    @JsonIgnore
    public String getScope() {
        return this.scope;
    }

    @JsonIgnore
    public String getGroup() {
        return HasMetadata.getGroup(this.getClass());
    }

    @JsonIgnore
    public String getVersion() {
        return HasMetadata.getVersion(this.getClass());
    }

    public S getSpec() {
        return this.spec;
    }

    public void setSpec(S spec) {
        this.spec = spec;
    }

    public T getStatus() {
        return this.status;
    }

    public void setStatus(T status) {
        this.status = status;
    }
}

