/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RBDPersistentVolumeSourceFluentImpl<A extends RBDPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements RBDPersistentVolumeSourceFluent<A> {
    private String fsType;
    private String image;
    private String keyring;
    private List<String> monitors = new ArrayList<String>();
    private String pool;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String user;

    public RBDPersistentVolumeSourceFluentImpl() {
    }

    public RBDPersistentVolumeSourceFluentImpl(RBDPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withImage(instance.getImage());
        this.withKeyring(instance.getKeyring());
        this.withMonitors(instance.getMonitors());
        this.withPool(instance.getPool());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getKeyring() {
        return this.keyring;
    }

    @Override
    public A withKeyring(String keyring) {
        this.keyring = keyring;
        return (A)this;
    }

    @Override
    public Boolean hasKeyring() {
        return this.keyring != null;
    }

    @Override
    public A withNewKeyring(String arg1) {
        return this.withKeyring(new String(arg1));
    }

    @Override
    public A withNewKeyring(StringBuilder arg1) {
        return this.withKeyring(new String(arg1));
    }

    @Override
    public A withNewKeyring(StringBuffer arg1) {
        return this.withKeyring(new String(arg1));
    }

    @Override
    public A addToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    @Override
    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    @Override
    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    @Override
    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        if (this.monitors != null) {
            this._visitables.get("monitors").removeAll(this.monitors);
        }
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    @Override
    public A addNewMonitor(String arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public A addNewMonitor(StringBuilder arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public A addNewMonitor(StringBuffer arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    @Override
    public Boolean hasPool() {
        return this.pool != null;
    }

    @Override
    public A withNewPool(String arg1) {
        return this.withPool(new String(arg1));
    }

    @Override
    public A withNewPool(StringBuilder arg1) {
        return this.withPool(new String(arg1));
    }

    @Override
    public A withNewPool(StringBuffer arg1) {
        return this.withPool(new String(arg1));
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A withNewUser(String arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuilder arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuffer arg1) {
        return this.withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBDPersistentVolumeSourceFluentImpl that = (RBDPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.keyring != null ? !this.keyring.equals(that.keyring) : that.keyring != null) {
            return false;
        }
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.pool != null ? !this.pool.equals(that.pool) : that.pool != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<RBDPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements RBDPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RBDPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

