/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetricSource;
import io.fabric8.kubernetes.api.model.ObjectMetricSourceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;

public class ObjectMetricSourceFluentImpl<A extends ObjectMetricSourceFluent<A>>
extends BaseFluent<A>
implements ObjectMetricSourceFluent<A> {
    private QuantityBuilder averageValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private CrossVersionObjectReferenceBuilder target;
    private QuantityBuilder targetValue;

    public ObjectMetricSourceFluentImpl() {
    }

    public ObjectMetricSourceFluentImpl(ObjectMetricSource instance) {
        this.withAverageValue(instance.getAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
        this.withTargetValue(instance.getTargetValue());
    }

    @Override
    @Deprecated
    public Quantity getAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public Quantity buildAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this._visitables.get("averageValue").remove(this.averageValue);
        if (averageValue != null) {
            this.averageValue = new QuantityBuilder(averageValue);
            this._visitables.get("averageValue").add(this.averageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    @Override
    public ObjectMetricSourceFluent.AverageValueNested<A> withNewAverageValue() {
        return new AverageValueNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item) {
        return new AverageValueNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.AverageValueNested<A> editAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue());
    }

    @Override
    public ObjectMetricSourceFluent.AverageValueNested<A> editOrNewAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item) {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : item);
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(CrossVersionObjectReference target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new CrossVersionObjectReferenceBuilder(target);
            this._visitables.get("target").add(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public A withNewTarget(String apiVersion, String kind, String name) {
        return this.withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    @Deprecated
    public Quantity getTargetValue() {
        return this.targetValue != null ? this.targetValue.build() : null;
    }

    @Override
    public Quantity buildTargetValue() {
        return this.targetValue != null ? this.targetValue.build() : null;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this._visitables.get("targetValue").remove(this.targetValue);
        if (targetValue != null) {
            this.targetValue = new QuantityBuilder(targetValue);
            this._visitables.get("targetValue").add(this.targetValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    @Override
    public ObjectMetricSourceFluent.TargetValueNested<A> withNewTargetValue() {
        return new TargetValueNestedImpl();
    }

    @Override
    public ObjectMetricSourceFluent.TargetValueNested<A> withNewTargetValueLike(Quantity item) {
        return new TargetValueNestedImpl(item);
    }

    @Override
    public ObjectMetricSourceFluent.TargetValueNested<A> editTargetValue() {
        return this.withNewTargetValueLike(this.getTargetValue());
    }

    @Override
    public ObjectMetricSourceFluent.TargetValueNested<A> editOrNewTargetValue() {
        return this.withNewTargetValueLike(this.getTargetValue() != null ? this.getTargetValue() : new QuantityBuilder().build());
    }

    @Override
    public ObjectMetricSourceFluent.TargetValueNested<A> editOrNewTargetValueLike(Quantity item) {
        return this.withNewTargetValueLike(this.getTargetValue() != null ? this.getTargetValue() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetricSourceFluentImpl that = (ObjectMetricSourceFluentImpl)o;
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.targetValue != null ? !this.targetValue.equals(that.targetValue) : that.targetValue != null);
    }

    public class TargetValueNestedImpl<N>
    extends QuantityFluentImpl<ObjectMetricSourceFluent.TargetValueNested<N>>
    implements ObjectMetricSourceFluent.TargetValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        TargetValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        TargetValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withTargetValue(this.builder.build());
        }

        @Override
        public N endTargetValue() {
            return this.and();
        }
    }

    public class TargetNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<ObjectMetricSourceFluent.TargetNested<N>>
    implements ObjectMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        private final CrossVersionObjectReferenceBuilder builder;

        TargetNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ObjectMetricSourceFluent.SelectorNested<N>>
    implements ObjectMetricSourceFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class AverageValueNestedImpl<N>
    extends QuantityFluentImpl<ObjectMetricSourceFluent.AverageValueNested<N>>
    implements ObjectMetricSourceFluent.AverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        AverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        AverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricSourceFluentImpl.this.withAverageValue(this.builder.build());
        }

        @Override
        public N endAverageValue() {
            return this.and();
        }
    }
}

