/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6.apps;

import io.fabric8.kubernetes.api.builder.v4_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_6.Nested;
import io.fabric8.kubernetes.api.model.v4_6.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_6.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_6.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.apps.Deployment;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentStatusBuilder;
import io.fabric8.kubernetes.api.model.v4_6.apps.DeploymentStatusFluentImpl;

public class DeploymentFluentImpl<A extends DeploymentFluent<A>>
extends BaseFluent<A>
implements DeploymentFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DeploymentSpecBuilder spec;
    private DeploymentStatusBuilder status;

    public DeploymentFluentImpl() {
    }

    public DeploymentFluentImpl(Deployment instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DeploymentFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public DeploymentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public DeploymentSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public DeploymentSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(DeploymentSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new DeploymentSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public DeploymentFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DeploymentFluent.SpecNested<A> withNewSpecLike(DeploymentSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DeploymentFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DeploymentFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new DeploymentSpecBuilder().build());
    }

    @Override
    public DeploymentFluent.SpecNested<A> editOrNewSpecLike(DeploymentSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public DeploymentStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public DeploymentStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(DeploymentStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new DeploymentStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public DeploymentFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DeploymentFluent.StatusNested<A> withNewStatusLike(DeploymentStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DeploymentFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public DeploymentFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new DeploymentStatusBuilder().build());
    }

    @Override
    public DeploymentFluent.StatusNested<A> editOrNewStatusLike(DeploymentStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentFluentImpl that = (DeploymentFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends DeploymentStatusFluentImpl<DeploymentFluent.StatusNested<N>>
    implements DeploymentFluent.StatusNested<N>,
    Nested<N> {
        private final DeploymentStatusBuilder builder;

        StatusNestedImpl(DeploymentStatus item) {
            this.builder = new DeploymentStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new DeploymentStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DeploymentSpecFluentImpl<DeploymentFluent.SpecNested<N>>
    implements DeploymentFluent.SpecNested<N>,
    Nested<N> {
        private final DeploymentSpecBuilder builder;

        SpecNestedImpl(DeploymentSpec item) {
            this.builder = new DeploymentSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DeploymentSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DeploymentFluent.MetadataNested<N>>
    implements DeploymentFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

