/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6;

import io.fabric8.kubernetes.api.builder.v4_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_6.Nested;
import io.fabric8.kubernetes.api.builder.v4_6.Predicate;
import io.fabric8.kubernetes.api.model.v4_6.Config;
import io.fabric8.kubernetes.api.model.v4_6.ConfigFluent;
import io.fabric8.kubernetes.api.model.v4_6.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v4_6.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.v4_6.NamedAuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.NamedCluster;
import io.fabric8.kubernetes.api.model.v4_6.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.v4_6.NamedClusterFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.NamedContext;
import io.fabric8.kubernetes.api.model.v4_6.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.v4_6.NamedContextFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.NamedExtension;
import io.fabric8.kubernetes.api.model.v4_6.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.v4_6.NamedExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_6.Preferences;
import io.fabric8.kubernetes.api.model.v4_6.PreferencesBuilder;
import io.fabric8.kubernetes.api.model.v4_6.PreferencesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigFluentImpl<A extends ConfigFluent<A>>
extends BaseFluent<A>
implements ConfigFluent<A> {
    private String apiVersion;
    private List<NamedClusterBuilder> clusters;
    private List<NamedContextBuilder> contexts;
    private String currentContext;
    private List<NamedExtensionBuilder> extensions;
    private String kind;
    private PreferencesBuilder preferences;
    private List<NamedAuthInfoBuilder> users;

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(Config instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToClusters(int index, NamedCluster item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<NamedClusterBuilder>();
        }
        NamedClusterBuilder builder = new NamedClusterBuilder(item);
        this._visitables.get("clusters").add(index >= 0 ? index : this._visitables.get("clusters").size(), builder);
        this.clusters.add(index >= 0 ? index : this.clusters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusters(int index, NamedCluster item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<NamedClusterBuilder>();
        }
        NamedClusterBuilder builder = new NamedClusterBuilder(item);
        if (index < 0 || index >= this._visitables.get("clusters").size()) {
            this._visitables.get("clusters").add(builder);
        } else {
            this._visitables.get("clusters").set(index, builder);
        }
        if (index < 0 || index >= this.clusters.size()) {
            this.clusters.add(builder);
        } else {
            this.clusters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusters(NamedCluster ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<NamedClusterBuilder>();
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get("clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusters(Collection<NamedCluster> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<NamedClusterBuilder>();
        }
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get("clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get("clusters").remove(builder);
            if (this.clusters == null) continue;
            this.clusters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusters(Collection<NamedCluster> items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.get("clusters").remove(builder);
            if (this.clusters == null) continue;
            this.clusters.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedCluster> getClusters() {
        return ConfigFluentImpl.build(this.clusters);
    }

    @Override
    public List<NamedCluster> buildClusters() {
        return ConfigFluentImpl.build(this.clusters);
    }

    @Override
    public NamedCluster buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    @Override
    public NamedCluster buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    @Override
    public NamedCluster buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    @Override
    public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        for (NamedClusterBuilder item : this.clusters) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        for (NamedClusterBuilder item : this.clusters) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusters(List<NamedCluster> clusters) {
        if (this.clusters != null) {
            this._visitables.get("clusters").removeAll(this.clusters);
        }
        if (clusters != null) {
            this.clusters = new ArrayList<NamedClusterBuilder>();
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = new ArrayList<NamedClusterBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withClusters(NamedCluster ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
        }
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    @Override
    public ConfigFluent.ClustersNested<A> addNewCluster() {
        return new ClustersNestedImpl();
    }

    @Override
    public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item) {
        return new ClustersNestedImpl(-1, item);
    }

    @Override
    public ConfigFluent.ClustersNested<A> setNewClusterLike(int index, NamedCluster item) {
        return new ClustersNestedImpl(index, item);
    }

    @Override
    public ConfigFluent.ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public ConfigFluent.ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    @Override
    public ConfigFluent.ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public ConfigFluent.ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.apply(this.clusters.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public A addToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContextBuilder>();
        }
        NamedContextBuilder builder = new NamedContextBuilder(item);
        this._visitables.get("contexts").add(index >= 0 ? index : this._visitables.get("contexts").size(), builder);
        this.contexts.add(index >= 0 ? index : this.contexts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContextBuilder>();
        }
        NamedContextBuilder builder = new NamedContextBuilder(item);
        if (index < 0 || index >= this._visitables.get("contexts").size()) {
            this._visitables.get("contexts").add(builder);
        } else {
            this._visitables.get("contexts").set(index, builder);
        }
        if (index < 0 || index >= this.contexts.size()) {
            this.contexts.add(builder);
        } else {
            this.contexts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContexts(NamedContext ... items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContextBuilder>();
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get("contexts").add(builder);
            this.contexts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContextBuilder>();
        }
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get("contexts").add(builder);
            this.contexts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get("contexts").remove(builder);
            if (this.contexts == null) continue;
            this.contexts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContexts(Collection<NamedContext> items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.get("contexts").remove(builder);
            if (this.contexts == null) continue;
            this.contexts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedContext> getContexts() {
        return ConfigFluentImpl.build(this.contexts);
    }

    @Override
    public List<NamedContext> buildContexts() {
        return ConfigFluentImpl.build(this.contexts);
    }

    @Override
    public NamedContext buildContext(int index) {
        return this.contexts.get(index).build();
    }

    @Override
    public NamedContext buildFirstContext() {
        return this.contexts.get(0).build();
    }

    @Override
    public NamedContext buildLastContext() {
        return this.contexts.get(this.contexts.size() - 1).build();
    }

    @Override
    public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate) {
        for (NamedContextBuilder item : this.contexts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate) {
        for (NamedContextBuilder item : this.contexts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContexts(List<NamedContext> contexts) {
        if (this.contexts != null) {
            this._visitables.get("contexts").removeAll(this.contexts);
        }
        if (contexts != null) {
            this.contexts = new ArrayList<NamedContextBuilder>();
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        } else {
            this.contexts = new ArrayList<NamedContextBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withContexts(NamedContext ... contexts) {
        if (this.contexts != null) {
            this.contexts.clear();
        }
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContexts() {
        return this.contexts != null && !this.contexts.isEmpty();
    }

    @Override
    public ConfigFluent.ContextsNested<A> addNewContext() {
        return new ContextsNestedImpl();
    }

    @Override
    public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item) {
        return new ContextsNestedImpl(-1, item);
    }

    @Override
    public ConfigFluent.ContextsNested<A> setNewContextLike(int index, NamedContext item) {
        return new ContextsNestedImpl(index, item);
    }

    @Override
    public ConfigFluent.ContextsNested<A> editContext(int index) {
        if (this.contexts.size() <= index) {
            throw new RuntimeException("Can't edit contexts. Index exceeds size.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    @Override
    public ConfigFluent.ContextsNested<A> editFirstContext() {
        if (this.contexts.size() == 0) {
            throw new RuntimeException("Can't edit first contexts. The list is empty.");
        }
        return this.setNewContextLike(0, this.buildContext(0));
    }

    @Override
    public ConfigFluent.ContextsNested<A> editLastContext() {
        int index = this.contexts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last contexts. The list is empty.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    @Override
    public ConfigFluent.ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.contexts.size(); ++i) {
            if (!predicate.apply(this.contexts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching contexts. No match found.");
        }
        return this.setNewContextLike(index, this.buildContext(index));
    }

    @Override
    public String getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public A withCurrentContext(String currentContext) {
        this.currentContext = currentContext;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentContext() {
        return this.currentContext != null;
    }

    @Override
    public A withNewCurrentContext(String arg1) {
        return this.withCurrentContext(new String(arg1));
    }

    @Override
    public A withNewCurrentContext(StringBuilder arg1) {
        return this.withCurrentContext(new String(arg1));
    }

    @Override
    public A withNewCurrentContext(StringBuffer arg1) {
        return this.withCurrentContext(new String(arg1));
    }

    @Override
    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.get("extensions").add(index >= 0 ? index : this._visitables.get("extensions").size(), builder);
        this.extensions.add(index >= 0 ? index : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.get("extensions").size()) {
            this._visitables.get("extensions").add(builder);
        } else {
            this._visitables.get("extensions").set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return ConfigFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return ConfigFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").removeAll(this.extensions);
        }
        if (extensions != null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public ConfigFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.apply(this.extensions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public Preferences getPreferences() {
        return this.preferences != null ? this.preferences.build() : null;
    }

    @Override
    public Preferences buildPreferences() {
        return this.preferences != null ? this.preferences.build() : null;
    }

    @Override
    public A withPreferences(Preferences preferences) {
        this._visitables.get("preferences").remove(this.preferences);
        if (preferences != null) {
            this.preferences = new PreferencesBuilder(preferences);
            this._visitables.get("preferences").add(this.preferences);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreferences() {
        return this.preferences != null;
    }

    @Override
    public ConfigFluent.PreferencesNested<A> withNewPreferences() {
        return new PreferencesNestedImpl();
    }

    @Override
    public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item) {
        return new PreferencesNestedImpl(item);
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editPreferences() {
        return this.withNewPreferencesLike(this.getPreferences());
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editOrNewPreferences() {
        return this.withNewPreferencesLike(this.getPreferences() != null ? this.getPreferences() : new PreferencesBuilder().build());
    }

    @Override
    public ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item) {
        return this.withNewPreferencesLike(this.getPreferences() != null ? this.getPreferences() : item);
    }

    @Override
    public A addToUsers(int index, NamedAuthInfo item) {
        if (this.users == null) {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
        }
        NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
        this._visitables.get("users").add(index >= 0 ? index : this._visitables.get("users").size(), builder);
        this.users.add(index >= 0 ? index : this.users.size(), builder);
        return (A)this;
    }

    @Override
    public A setToUsers(int index, NamedAuthInfo item) {
        if (this.users == null) {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
        }
        NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
        if (index < 0 || index >= this._visitables.get("users").size()) {
            this._visitables.get("users").add(builder);
        } else {
            this._visitables.get("users").set(index, builder);
        }
        if (index < 0 || index >= this.users.size()) {
            this.users.add(builder);
        } else {
            this.users.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToUsers(NamedAuthInfo ... items) {
        if (this.users == null) {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get("users").add(builder);
            this.users.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<NamedAuthInfo> items) {
        if (this.users == null) {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
        }
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get("users").add(builder);
            this.users.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get("users").remove(builder);
            if (this.users == null) continue;
            this.users.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<NamedAuthInfo> items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.get("users").remove(builder);
            if (this.users == null) continue;
            this.users.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedAuthInfo> getUsers() {
        return ConfigFluentImpl.build(this.users);
    }

    @Override
    public List<NamedAuthInfo> buildUsers() {
        return ConfigFluentImpl.build(this.users);
    }

    @Override
    public NamedAuthInfo buildUser(int index) {
        return this.users.get(index).build();
    }

    @Override
    public NamedAuthInfo buildFirstUser() {
        return this.users.get(0).build();
    }

    @Override
    public NamedAuthInfo buildLastUser() {
        return this.users.get(this.users.size() - 1).build();
    }

    @Override
    public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        for (NamedAuthInfoBuilder item : this.users) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        for (NamedAuthInfoBuilder item : this.users) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsers(List<NamedAuthInfo> users) {
        if (this.users != null) {
            this._visitables.get("users").removeAll(this.users);
        }
        if (users != null) {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = new ArrayList<NamedAuthInfoBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withUsers(NamedAuthInfo ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public ConfigFluent.UsersNested<A> addNewUser() {
        return new UsersNestedImpl();
    }

    @Override
    public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item) {
        return new UsersNestedImpl(-1, item);
    }

    @Override
    public ConfigFluent.UsersNested<A> setNewUserLike(int index, NamedAuthInfo item) {
        return new UsersNestedImpl(index, item);
    }

    @Override
    public ConfigFluent.UsersNested<A> editUser(int index) {
        if (this.users.size() <= index) {
            throw new RuntimeException("Can't edit users. Index exceeds size.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    @Override
    public ConfigFluent.UsersNested<A> editFirstUser() {
        if (this.users.size() == 0) {
            throw new RuntimeException("Can't edit first users. The list is empty.");
        }
        return this.setNewUserLike(0, this.buildUser(0));
    }

    @Override
    public ConfigFluent.UsersNested<A> editLastUser() {
        int index = this.users.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last users. The list is empty.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    @Override
    public ConfigFluent.UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.users.size(); ++i) {
            if (!predicate.apply(this.users.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching users. No match found.");
        }
        return this.setNewUserLike(index, this.buildUser(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.contexts != null ? !this.contexts.equals(that.contexts) : that.contexts != null) {
            return false;
        }
        if (this.currentContext != null ? !this.currentContext.equals(that.currentContext) : that.currentContext != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.preferences != null ? !this.preferences.equals(that.preferences) : that.preferences != null) {
            return false;
        }
        return !(this.users != null ? !this.users.equals(that.users) : that.users != null);
    }

    public class UsersNestedImpl<N>
    extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>>
    implements ConfigFluent.UsersNested<N>,
    Nested<N> {
        private final NamedAuthInfoBuilder builder;
        private final int index;

        UsersNestedImpl(int index, NamedAuthInfo item) {
            this.index = index;
            this.builder = new NamedAuthInfoBuilder(this, item);
        }

        UsersNestedImpl() {
            this.index = -1;
            this.builder = new NamedAuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.setToUsers(this.index, this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class PreferencesNestedImpl<N>
    extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>>
    implements ConfigFluent.PreferencesNested<N>,
    Nested<N> {
        private final PreferencesBuilder builder;

        PreferencesNestedImpl(Preferences item) {
            this.builder = new PreferencesBuilder(this, item);
        }

        PreferencesNestedImpl() {
            this.builder = new PreferencesBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.withPreferences(this.builder.build());
        }

        @Override
        public N endPreferences() {
            return this.and();
        }
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>>
    implements ConfigFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

        ExtensionsNestedImpl(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class ContextsNestedImpl<N>
    extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>>
    implements ConfigFluent.ContextsNested<N>,
    Nested<N> {
        private final NamedContextBuilder builder;
        private final int index;

        ContextsNestedImpl(int index, NamedContext item) {
            this.index = index;
            this.builder = new NamedContextBuilder(this, item);
        }

        ContextsNestedImpl() {
            this.index = -1;
            this.builder = new NamedContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.setToContexts(this.index, this.builder.build());
        }

        @Override
        public N endContext() {
            return this.and();
        }
    }

    public class ClustersNestedImpl<N>
    extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>>
    implements ConfigFluent.ClustersNested<N>,
    Nested<N> {
        private final NamedClusterBuilder builder;
        private final int index;

        ClustersNestedImpl(int index, NamedCluster item) {
            this.index = index;
            this.builder = new NamedClusterBuilder(this, item);
        }

        ClustersNestedImpl() {
            this.index = -1;
            this.builder = new NamedClusterBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.setToClusters(this.index, this.builder.build());
        }

        @Override
        public N endCluster() {
            return this.and();
        }
    }
}

