/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DoneableStatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.StatefulSetRollingUpdater;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class StatefulSetOperationsImpl
extends RollableScalableResourceOperation<StatefulSet, StatefulSetList, DoneableStatefulSet, RollableScalableResource<StatefulSet, DoneableStatefulSet>>
implements TimeoutImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> {
    public StatefulSetOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withCascading(true));
    }

    public StatefulSetOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("statefulsets"));
        this.type = StatefulSet.class;
        this.listType = StatefulSetList.class;
        this.doneableType = DoneableStatefulSet.class;
    }

    public StatefulSetOperationsImpl newInstance(OperationContext context) {
        return new StatefulSetOperationsImpl((RollingOperationContext)context);
    }

    @Override
    StatefulSet withReplicas(int count) {
        return ((DoneableStatefulSet)((StatefulSetFluent.SpecNested)((DoneableStatefulSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<StatefulSet, StatefulSetList, DoneableStatefulSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new StatefulSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(StatefulSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(StatefulSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(StatefulSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public StatefulSetOperationsImpl rolling() {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public StatefulSet updateImage(String image) {
        StatefulSet oldRC = (StatefulSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing StatefulSet doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        StatefulSetBuilder newRCBuilder = new StatefulSetBuilder(oldRC);
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new StatefulSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeout(long timeout, TimeUnit unit) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<StatefulSet, StatefulSet, DoneableStatefulSet> withTimeoutInMillis(long timeoutInMillis) {
        return new StatefulSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }
}

