/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeConfigStatus;
import io.fabric8.kubernetes.api.model.NodeConfigStatusFluent;
import io.fabric8.kubernetes.api.model.NodeConfigStatusFluentImpl;
import javax.validation.Validator;

public class NodeConfigStatusBuilder
extends NodeConfigStatusFluentImpl<NodeConfigStatusBuilder>
implements VisitableBuilder<NodeConfigStatus, NodeConfigStatusBuilder> {
    NodeConfigStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeConfigStatusBuilder() {
        this(true);
    }

    public NodeConfigStatusBuilder(Boolean validationEnabled) {
        this(new NodeConfigStatus(), validationEnabled);
    }

    public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeConfigStatus(), validationEnabled);
    }

    public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent, NodeConfigStatus instance) {
        this(fluent, instance, true);
    }

    public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent, NodeConfigStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActive(instance.getActive());
        fluent.withAssigned(instance.getAssigned());
        fluent.withError(instance.getError());
        fluent.withLastKnownGood(instance.getLastKnownGood());
        this.validationEnabled = validationEnabled;
    }

    public NodeConfigStatusBuilder(NodeConfigStatus instance) {
        this(instance, (Boolean)true);
    }

    public NodeConfigStatusBuilder(NodeConfigStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActive(instance.getActive());
        this.withAssigned(instance.getAssigned());
        this.withError(instance.getError());
        this.withLastKnownGood(instance.getLastKnownGood());
        this.validationEnabled = validationEnabled;
    }

    public NodeConfigStatusBuilder(Validator validator) {
        this(new NodeConfigStatus(), (Boolean)true);
    }

    public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent, NodeConfigStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withActive(instance.getActive());
        fluent.withAssigned(instance.getAssigned());
        fluent.withError(instance.getError());
        fluent.withLastKnownGood(instance.getLastKnownGood());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeConfigStatusBuilder(NodeConfigStatus instance, Validator validator) {
        this.fluent = this;
        this.withActive(instance.getActive());
        this.withAssigned(instance.getAssigned());
        this.withError(instance.getError());
        this.withLastKnownGood(instance.getLastKnownGood());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeConfigStatus build() {
        NodeConfigStatus buildable = new NodeConfigStatus(this.fluent.getActive(), this.fluent.getAssigned(), this.fluent.getError(), this.fluent.getLastKnownGood());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigStatusBuilder that = (NodeConfigStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

