/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import javax.validation.Validator;

public class TemplateBuilder
extends TemplateFluentImpl<TemplateBuilder>
implements VisitableBuilder<Template, TemplateBuilder> {
    TemplateFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TemplateBuilder() {
        this(true);
    }

    public TemplateBuilder(Boolean validationEnabled) {
        this(new Template(), validationEnabled);
    }

    public TemplateBuilder(TemplateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Template(), validationEnabled);
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Template instance) {
        this(fluent, instance, true);
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Template instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withMetadata(instance.getMetadata());
        fluent.withObjects(instance.getObjects());
        fluent.withParameters(instance.getParameters());
        this.validationEnabled = validationEnabled;
    }

    public TemplateBuilder(Template instance) {
        this(instance, (Boolean)true);
    }

    public TemplateBuilder(Template instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withMetadata(instance.getMetadata());
        this.withObjects(instance.getObjects());
        this.withParameters(instance.getParameters());
        this.validationEnabled = validationEnabled;
    }

    public TemplateBuilder(Validator validator) {
        this(new Template(), (Boolean)true);
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Template instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withMetadata(instance.getMetadata());
        fluent.withObjects(instance.getObjects());
        fluent.withParameters(instance.getParameters());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TemplateBuilder(Template instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withMetadata(instance.getMetadata());
        this.withObjects(instance.getObjects());
        this.withParameters(instance.getParameters());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Template build() {
        Template buildable = new Template(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getMetadata(), this.fluent.getObjects(), this.fluent.getParameters());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateBuilder that = (TemplateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

